<?php
namespace WpBookingHotel\Wordpress;
use BlockController;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

abstract class TBPRO_Widget_Base extends Widget_Base  {

    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        $class_call= get_called_class();
        $class_call=strtolower($class_call);
        $class_call=str_replace("widget","",$class_call);
        return  $class_call;
    }
    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        $class_call= get_called_class();
        $class_call=strtolower($class_call);
        $class_call=str_replace("widget","",$class_call);
        $class_call=str_replace("_"," ",$class_call);
        return esc_html( $class_call);
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'general' ];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends() {
        return [ 'wpbookinghotel' ];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function _register_controls() {

    }

    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function get_setting($data=array()) {
        $settings = $this->get_settings_for_display();
    }
    public function get_data_config($settings) {
        $data_setting=new \stdClass();
       return $data_setting;
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $data_setting=$this->get_data_config($settings);
        $data_setting=json_encode($data_setting);
        $data_setting=str_replace(' ', '%%%%',$data_setting);
        $data_setting=str_ireplace(array("[","]"),array("!!!!","@@@@"),$data_setting);
        $data_setting=str_ireplace(array("<",">"),array("&lt;","&gt;"),$data_setting);
        $id=$this->get_id();
        $input=Factory::getInput();
        $input->set('open_source_client_id',$id);
        $block_name=$this->get_name();
        $input->set('type',$block_name);
        $data=$input->getData();
        ob_start();
        ?>
        [wpbookinghotel_elementor_block block_name="<?php Text::_echo_no_translate($block_name) ?>" open_source_client_id="<?php Text::_echo_no_translate($id) ?>" data_setting=<?php echo ($data_setting) ?>]
        <?php
        $content=ob_get_clean();
        echo ($content);

    }

    /**
     * Render the widget output in the editor.
     *
     * Written as a Backbone JavaScript template and used to generate the live preview.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function _content_template() {
        ?>
        <div class="title">
            {{{ settings.title }}}
        </div>
        <?php
    }
}
