<?php
namespace WpBookingHotel\Html;
use WpBookingHotel\Factory;

/**
 * Class WpBookingHotelHtmlFrontend
 * @package WpBookingHotel\Html
 */
class WpBookingHotelHtmlFrontend
{
    /**
     * @var array
     */
    private static $loaded=array();

    /**
     * @param $key
     */
    public static function load_jquery_library($key)
    {
        static::call($key);
    }

    /**
     *
     */
    public static function lazy_load()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("frontend/resources/jquery.lazy/jquery.lazy.js");
            static::$loaded[__METHOD__] = true;
        }
    }
    public static function loading_js()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/loading_js/css/jquery.loadingModal.min.css');
            $doc->addScript("frontend/resources/loading_js/js/jquery.loadingModal.min.js");
            static::$loaded[__METHOD__] = true;
        }
    }
    /**
     *
     */
    public static function datatables()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("https://cdn.datatables.net/1.10.20/js/jquery.dataTables.min.js");
            $doc->addStyleSheet('https://cdn.datatables.net/1.10.20/css/jquery.dataTables.min.css');
            $doc->addStyleSheet('https://cdn.datatables.net/1.10.20/css/dataTables.bootstrap4.min.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    public static function twbs_pagination($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/twbs-pagination/jquery.twbsPagination.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function main_app()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScriptApplySelector('body', 'view_main_app_frontend', array(), 'frontend/app/assets/js/view_main_app.js');
            $doc->addLessStyleSheet('frontend/app/assets/less/view_main_app.less');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     *
     */
    public static function bootstrap()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("frontend/resources/bootstrap3.3.7/bootstrap.min.js");
            $doc->addStyleSheet('frontend/resources/bootstrap3.3.7/bootstrap.min.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function awesome()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/fontawesome-free-5.12.1/css/all.min.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    public static function increment($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/jquery-Increment/dist/js/handleCounter.js');
            $doc->addStyleSheet('frontend/resources/jquery-Increment/dist/css/handle-counter.min.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function ui()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript('admin/resources/jquery-ui-1.11.3/jquery-ui.js');
            $doc->addStyleSheet('admin/resources/jquery-ui-1.11.3/jquery-ui.css');
            static::$loaded[__METHOD__] = true;
        }
    }
    /**
     *
     */
    public static function starrr()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript('frontend/resources/starrr-gh-pages/dist/starrr.js');
            $doc->addStyleSheet('frontend/resources/starrr-gh-pages/dist/starrr.css');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     *
     */
    public static function confirm()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/jquery-confirm-master/dist/jquery-confirm.min.css');
            $doc->addScript('frontend/resources/jquery-confirm-master/dist/jquery-confirm.min.js');
            static::$loaded[__METHOD__] = true;
        }
    }


    /**
     * @param null $debug
     */
    public static function daterangepicker($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/daterangepicker-master/daterangepicker.css');
            $doc->addScript('frontend/resources/daterangepicker-master/daterangepicker.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function fontawesome($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/fontawesome-free-5.12.1/css/all.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    public static function datepickertime($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/bootstrap-datetimepicker-master/css/bootstrap-datetimepicker.min.css');
            $doc->addScript('frontend/resources/bootstrap-datetimepicker-master/js/bootstrap-datetimepicker.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function less()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/less/less.min.js');
            static::$loaded[__METHOD__] = true;
        }
    }

    /**
     * @param null $debug
     */
    public static function moment($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/daterangepicker-master/moment.min.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function select2($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/select2-4.0.12/dist/js/select2.full.min.js');
            $doc->addStyleSheet('frontend/resources/select2-4.0.12/dist/css/select2.min.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function ionrangeSlider($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/ion.rangeSlider-master/js/ion.rangeSlider.js');
            $doc->addStyleSheet('frontend/resources/ion.rangeSlider-master/css/ion.rangeSlider.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     * @param null $debug
     */
    public static function icheck($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/icheck-1.x/icheck.min.js');
            $doc->addStyleSheet('frontend/resources/icheck-1.x/skins/all.css');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    /**
     *
     */
    public static function owlcarousel2()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("frontend/resources/OwlCarousel2-2.3.4/dist/owl.carousel.min.js");
            $doc->addStyleSheet('frontend/resources/OwlCarousel2-2.3.4/dist/assets/owl.carousel.min.css');
            static::$loaded[__METHOD__] = true;
        }
    }
    public static function slick()
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc=Factory::getDocument();
            $doc->addScript("frontend/resources/slick/slick.js");
            $doc->addStyleSheet('frontend/resources/slick/slick.css');
            $doc->addStyleSheet('frontend/resources/slick/slick-theme.css');
            static::$loaded[__METHOD__] = true;
        }
    }


    /**
     * @param $function
     */
    protected static function call($function)
    {
        call_user_func(array("WpBookingHotel\Html\WpBookingHotelHtmlFrontend",$function));
    }
    public static function validate($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addScript('frontend/resources/jquery-validation/dist/jquery.validate.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }

    public static function store_locator_js($debug = null)
    {
        if (empty(static::$loaded[__METHOD__])) {
            $doc = Factory::getDocument();
            $doc->addStyleSheet('frontend/resources/store_locator/assets/css/storelocator.css');
            $doc->addScript('frontend/resources/store_locator/assets/js/libs/handlebars.min.js');
            $doc->addScript('https://maps.google.com/maps/api/js?key=AIzaSyBpDfhWdXiNkJ4fVf4pkB7Q9ig90oiricw');
            $doc->addScript('frontend/resources/store_locator/assets/js/plugins/storeLocator/jquery.storelocator.js');
            static::$loaded[__METHOD__] = true;
        }
        return;
    }
}