<?php
/**
 * @package     woobooking.Platform
 * @subpackage  Form
 *
 *  Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
namespace WpBookingHotel\Form\fields;
defined('_WPBOOKINGHOTEL_EXEC') or die;
use WpBookingHotel\Form\FormField;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend;
use WpBookingHotel\Language\Text;

/**
 * Form Field class for the woobooking Platform.
 * Supports a one line text field.
 *
 * @link   http://www.w3.org/TR/html-markup/input.text.html#input.text

 */
class WpBookingHotel_FormFieldTotalpeople2 extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'totalpeople2';
    /**
     * Name of the layout being used to render the field
     *
     * @var    string
     */
    protected $layout = 'WooBooking.form.field.totalpeople2.totalpeople2';

    protected function getLayoutData()
    {
        $data = parent::getLayoutData();

        $extraData = array(
            'name_field_number_adult'   => $this->element['name_field_number_adult'],
            'name_field_number_child'   => $this->element['name_field_number_child'],
            'default_value_field_number_adult'   => $this->element['default_value_field_number_adult'],
            'default_value_field_number_child'   => $this->element['default_value_field_number_child'],
        );

        return array_merge($data, $extraData);
    }

}
