<?php
/**
 * @package     woobooking.Platform
 * @subpackage  Form
 *
 *  Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
namespace WpBookingHotel\Form\fields;
defined('_WPBOOKINGHOTEL_EXEC') or die;
use WpBookingHotel\Form\FormField;

/**
 * Form Field class for the woobooking Platform.
 * Supports a one line text field.
 *
 * @link   http://www.w3.org/TR/html-markup/input.text.html#input.text

 */
class WpBookingHotel_FormFieldRoomtypewithprice extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'roomtypewithprice';
    /**
     * Name of the layout being used to render the field
     *
     * @var    string
     */
    protected $layout = 'WooBooking.form.field.roomtypewithprice.roomtypewithprice';

    protected function getLayoutData()
    {
        $data = parent::getLayoutData();

        $extraData = array(
            'name_price_adult'   => $this->element['name_price_adult'],
            'name_price_child'   => $this->element['name_price_child'],
        );

        return array_merge($data, $extraData);
    }

}
