<?php
namespace WpBookingHotel;
use NBAppHelper;
use RuntimeException;
use wpbookinghotelconfig;
use WpBookingHotel\Application\Application as ApplicationAlias;
use WpBookingHotel\Document\Document;
use WpBookingHotel\FOFInput\FOFInput;
use WpBookingHotel\Language\Language;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Uri\NBUri;
use WpBookingHotel\WbDate\WbDate;
use WpBookingHotel\Wordpress\Wordpress;
use WpBookingHotel\Database\driver\DatabaseDriverMysqli;


/**
 * Class Factory
 * @package WpBookingHotel
 */
class Factory
{

    private static $input;
    private static $application;
    private static $document;
    public static $client;
    private static $dates;
    private static $open_source=null;

    public static function getInput()
    {
        if (!self::$input) {
            self::$input = new FOFInput();
        }
        return self::$input;
    }
    public static function getApplication($client)
    {
        if (!self::$application) {

            self::$application = ApplicationAlias::getInstance($client);
        }

        return self::$application;
    }
    public static function getUser()
    {
        
        $data1= wp_get_current_user();
       
        $user=$data1->data;
        if(!isset($user->ID)){
            return false;
        }
        $user->id=$user->ID;
        $user->username=$user->user_login;
        return $user;
    }
    public static function getApplicationClient(){
        return static::$client;
    }
    public static function setApplicationClient($client){
        static::$client=$client;
    }
    public static function getConfig(){
        $file=WPBOOKINGHOTEL_PATH_ROOT.DS."wpbookinghotelconfig.php";
        if (is_file($file))
        {
            include_once $file;
        }
        $registry = new Registry;
        $config=new wpbookinghotelconfig();
        $registry->loadObject($config);

        return $registry;
    }
    public static function getDocument():Document
    {
        if (!isset(static::$document)) {
            static::$document = new Document();
        }
        return static::$document;
    }

    public static function getWordpress($client=0):Wordpress
    {
        $app=ApplicationAlias::getInstance($client);
        return $app->getWordpress();

    }
    public static function getDate($time = 'now', $tzOffset = null)
    {
        if (!isset(self::$dates[$time]))
        {
            self::$dates[$time] = new WbDate($time, $tzOffset);
        }

        $date = clone self::$dates[$time];
        return $date;
    }

    public static function getRootUrlPlugin()
    {
        return WPBOOKINGHOTEL_PLUGIN_DIR_URL;
    }

    public static function getRootUrl()
    {
        return WPBOOKINGHOTEL_SITE_URL;
    }
    public static function getRootUrlBackend()
    {
        return WPBOOKINGHOTEL_SITE_URL."/wp-admin";
    }
    public static function getRootUrlBackendWooPanel()
    {
        return WPBOOKINGHOTEL_SITE_URL."/sellercenter";
    }
    public static function getDBO()
    {
        $host = DB_HOST;
        $user = DB_USER;
        $password = DB_PASSWORD;
        $database = DB_NAME;
        $prefix = "";
        $driver = "mysqli";
        $debug = true;
        $options = array('driver' => $driver, 'host' => $host, 'user' => $user, 'password' => $password, 'database' => $database, 'prefix' => $prefix);


        try {
            $db = DatabaseDriverMysqli::getInstance($options);
        } catch (RuntimeException $e) {
            if (!headers_sent()) {
                header('HTTP/1.1 500 Internal Server Error');
            }
            exit('Database Error: ' . $e->getMessage());
        }

        $db->setDebug($debug);
        return $db;
    }

    public static function getSession()
    {
    }

    public static function getAppConfig()
    {
        $db=Factory::getDBO();
        $query=$db->getQuery(true);
        $query->select("*")
            ->from(WPBOOKINGHOTEL_PREFIX_TABLE."config")
            ->where('id=1')
        ;
        $item=$db->setQuery($query)->loadObject();
        $param=$item->params;
        $reg=new Registry();
        $reg->loadString($param);
        return $reg;
    }

    public static function getUri($url="")
    {
        if($url!="")
            $uri=NBUri::getInstance($url);
        else
            $uri=NBUri::getInstance();
        return $uri;
    }

    public static function getLanguage()
    {
        $conf = self::getConfig();
        $locale = $conf->get('language');
        $debug = $conf->get('debug_lang');
        $lang = Language::getInstance($locale, $debug);
        return $lang;
    }
    public static function getOpenSource(){
        if (!isset(self::$open_source))
        {

            self::$open_source = Wordpress::getInstance();
        }
        return self::$open_source;
    }
}