<?php
namespace WpBookingHotel\Application;

use WpBookingHotel\Router\AdministratorRouter;
use WpBookingHotel\Router\Router;
use WpBookingHotel\Router\SiteRouter;
use WpBookingHotel\Factory;
use WpBookingHotel\FOFInput\FOFInput;

class Application
{
    private static $input;
    /**
     * @var array
     */
    public static $messages = array();
    public $wordpress;
    private static $instance = array();
    public static $instance_router = array();

    public static function getInstance($clientId = 0): Application
    {
        if (!isset(static::$instance[$clientId])) {
            if($clientId==2){
                static::$instance[$clientId] = new ApplicationAdminWoopanel();
            }else if ($clientId == 1) {
                static::$instance[$clientId] = new ApplicationAdmin();
            } else {
                $clientId = 0;
                static::$instance[$clientId] = new ApplicationSite();
            }
        }
        return static::$instance[$clientId];

    }
    public static function getRouter($clientId = 0): Router
    {
        if (!isset(static::$instance_router[$clientId])) {
            if ($clientId == 1) {
                static::$instance_router[$clientId] = new AdministratorRouter();
            } else {
                $clientId = 0;
                static::$instance_router[$clientId] = new SiteRouter();

            }
        }
        return static::$instance_router[$clientId];

    }


    public function execute()
    {

    }

    public static function getInput()
    {
        if (!self::$input) {
            self::$input = new FOFInput();
        }
        return self::$input;
    }

    public function getWordpress()
    {
        return $this->wordpress;
    }

    public function getUserStateFromRequest($key, $request, $default = null, $type = 'none')
    {
        $cur_state = $this->getUserState($key, $default);
        $new_state = new FOFInput();

        if ($new_state === null) {
            return $cur_state;
        }

        // Save the new value only if it was set in this request.
        $this->setUserState($key, $new_state);

        return $new_state;
    }

    public static function setUserState($key, $value)
    {
        $session = Factory::getSession();
        $registry = $session->get('registry');

        if ($registry !== null) {
            return $registry->set($key, $value);
        }

        return;
    }

    public function enqueueMessage($msg)
    {
        static::$messages[] = $msg;
    }

    public function getEnqueueMessage()
    {
        return static::$messages;
    }


}