<?php

use WpBookingHotel\Factory ;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotelFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;

$curent_user_id=Factory::getUser()->id;

$one_star = array();
$two_star = array();
$three_star = array();
$four_star = array();
$five_star = array();
$location_hotel = $list_hotel_location;

$page_hotel_detail= ConfigHelperAlias::get_page_hotel_detail();
if($page_hotel_detail) {
    $this->page_hotel_detail = get_page_link($page_hotel_detail);
}else{
    $this->page_hotel_detail="";
}
$params=$this->item->params;
$title_block=$params->get('title_block','');
$description=$params->get('description','');

?>
<div class="block-trending-destinations-hotel">
    <div class="title">
        <h3><?php echo (esc_html($title_block))?></h3>
        <span><?php echo (esc_html($description))?></span>
    </div>
    <ul class="nav nav-tabs">
        <li class="active"><a data-toggle="tab" href="#menu1"><?php esc_html_e('All','wpbookinghotel');?></a></li>
        <?php foreach ($location_hotel as $location_hotel_item) {?>

            <li><a data-toggle="tab" href="#menu-<?php echo (esc_html($location_hotel_item->id))?>"><?php esc_html_e($location_hotel_item->countryname,'wpbookinghotel')?></a></li>
        <?php } ?>
    </ul>
    <div class="tab-content">
        <div id="menu1" class="tab-pane fade in active">
            <?php foreach ($list_hotel_all as $hotel) {?>
                <?php
                $list_review = isset($hotel->list_review)?$hotel->list_review:array();
                if(!empty($list_review)) {
                    $rating_sum = 0;
                    foreach ($list_review as $review) {
                        if(isset($review->rating)) {
                            $rating_sum += $review->rating;
                        }
                    }
                    $max_star = 5;
                    $hotel_rating=$rating_sum / count($list_review);
                    while ($hotel_rating > $max_star) {
                        $hotel_rating = $hotel_rating - $max_star;
                    }

                    $star = $hotel_rating % 10;
                    $non_star = ($max_star - $hotel_rating) % 10;
                    $half_star = ceil($max_star-$star-$non_star);
                }
                ?>
                <div class="col-md-3 col-sm-6">
                    <div class="box-hotel row-1 box-1 wishlist-item" data-hotel_id= "<?php echo $hotel->id ?>" data-user_id= "<?php echo $curent_user_id ?>" >
                            <div class="img-block">
                            <a href="<?php echo($this->page_hotel_detail.'?hotel_id='.$hotel->id); ?>" style="display: block">
                                <div class="wishlist-hover">
                                    <img class="lazy" data-src="<?php echo(Factory::getRootUrlPlugin())?><?php echo (isset($hotel->image)?$hotel->image:'');?>"
                                         alt="<?php echo (isset($hotel->name)?$hotel->name:'');?>">
                                </div>
                            </a>
                                <div class="category-name-heart">
                                    <span class="heart <?php echo in_array($curent_user_id,$hotel->user_wishlist) ? 'active':'' ?> ">
                                        <i class="fas fa-heart"></i>
                                    </span>
                                </div>
                            </div>
                            <div class="block-content">
                                <div class="block-rating">
                                    <ul class="list-rating-star">
                                        <?php if(!empty($list_review)) {?>
                                            <?php for ($i=0; $i <$star; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$half_star; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$non_star; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        <?php } else {?>
                                            <?php for($i = 1; $i <= 5; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        <?php }?>
                                    </ul>
                                    <div class="rating-review">
                                        <span><?php echo (esc_html(count($list_review)));?></span>
                                        <span><?php esc_attr_e('Reviews','wpbookinghotel');?></span>
                                    </div>
                                </div>
                                <a href="<?php echo($this->page_hotel_detail.'?hotel_id='.$hotel->id); ?>" style="display: block">
                                    <div class="name-hotel text-1">
                                        <h4 title="<?php echo (isset($hotel->name)?$hotel->name:'');?>"><?php echo (isset($hotel->name)?$hotel->name:'');?></h4>
                                    </div>
                                </a>
                                <div class="address-hotel text-1">
                                    <i class="fas fa-map-marker-alt"></i>
                                    <span title="<?php echo (isset($hotel->location_address)?$hotel->location_address:'');?>">
                                        <?php echo (isset($hotel->location_address)?$hotel->location_address:'');?>
                                    </span>
                                </div>
                            </div>
                        <div class="price">
                            <span><?php echo(FrontendHelper::format_currency(isset($hotel->price)?$hotel->price:0))?></span>
                            <span><?php esc_html_e('Night','wpbookinghotel');?></span>
                        </div>
                        </div>
                </div>
            <?php }?>
        </div>
        <?php foreach ($location_hotel as $location_hotel_item) {?>
            <div id="menu-<?php echo (esc_attr($location_hotel_item->id))?>" class="tab-pane fade">
                <?php foreach ($location_hotel_item->list_location as $location_list) {?>
                    <?php foreach ($location_list->list_hotel as $item) {?>
                        <?php
                            $list_review = isset($item->list_review)?$item->list_review:array();
                            if(!empty($list_review)) {
                                $rating_sum = 0;
                                foreach ($list_review as $review) {
                                    if(isset($review->rating)) {
                                        $rating_sum += $review->rating;
                                    }
                                }
                                $max_star = 5;
                                $hotel_rating=$rating_sum / count($list_review);
                                while ($hotel_rating > $max_star) {
                                    $hotel_rating = $hotel_rating - $max_star;
                                }

                                $star = $hotel_rating % 10;
                                $non_star = ($max_star - $hotel_rating) % 10;
                                $half_star = ceil($max_star-$star-$non_star);
                            }
                        ?>
                        <div class="col-md-3">
                            <div class="box-hotel row-1 box-1">
                                <a href="<?php echo($this->page_hotel_detail.'?hotel_id='.$item->id); ?>" style="display: block">
                                    <div class="img-block">
                                        <div>
                                            <img class="lazy" data-src="<?php echo(Factory::getRootUrlPlugin())?><?php echo (isset($item->image)?$item->image:'');?>"
                                                 alt="<?php echo (isset($item->name)?$item->name:'');?>">
                                        </div>
                                    </div>
                                    <div class="block-content">
                                        <div class="block-rating">
                                            <ul class="list-rating-star">
                                                <?php if(!empty($list_review)) {?>
                                                    <?php for ($i=0; $i <$star; $i++) {?>
                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                    <?php }?>
                                                    <?php for ($i=0; $i <$half_star; $i++) {?>
                                                        <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                                    <?php }?>
                                                    <?php for ($i=0; $i <$non_star; $i++) {?>
                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                    <?php }?>
                                                <?php } else {?>
                                                    <?php for($i = 1; $i <= 5; $i++) {?>
                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                    <?php }?>
                                                <?php }?>
                                            </ul>
                                            <div class="rating-review">
                                                <span><?php echo (esc_html(count($list_review)));?></span>
                                                <span><?php esc_html_e('Reviews','wpbookinghotel');?></span>
                                            </div>
                                        </div>
                                        <div class="name-hotel text-1">
                                            <h4 title="<?php echo (isset($hotel->name)?$hotel->name:'');?>"><?php echo (isset($item->name)?$item->name:'');?></h4>
                                        </div>
                                        <div class="address-hotel text-1">
                                            <i class="fas fa-map-marker-alt"></i>
                                            <span title="<?php echo (!empty($location_list->address)?$location_list->address:'');?>">
                                                <?php echo (isset($location_list->address)?$location_list->address:'');?>
                                            </span>
                                        </div>
                                    </div>
                                </a>
                                <div class="price">
                                    <span><?php echo(FrontendHelper::format_currency(isset($item->price)?$item->price:0))?></span>
                                    <span><?php esc_html_e('Night','wpbookinghotel');?></span>
                                </div>
                            </div>
                        </div>
                    <?php }?>
                <?php }?>
        </div>
        <?php }?>

    </div>

</div>
<?php
$doc= Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('owlcarousel2');
$doc->addLessStyleSheet('frontend/blocks/block_trending_destinations_hotel/assets/less/block_trending_destinations_hotel.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block-trending-destinations-hotel','block_trending_destinations_hotel',array(

),'frontend/blocks/block_trending_destinations_hotel/assets/js/block_trending_destinations_hotel.js');