<?php
namespace WpBookingHotelBlock\block_top_reviews;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use WpBookingHotel\Wordpress\TBPRO_Widget_Base;
use WpBookingHotel\Wordpress\TBPRO_Widget_Base_Interface;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Class CategoriesWidget
 */
class top_reviewsWidget extends TBPRO_Widget_Base
{

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }
    public function get_name() {

        return  "top_reviews";
    }
    public function get_title() {

        return  "Top Reviews";
    }



    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_attr('Content', 'WpBookingHotel'),
            ]
        );
        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'wpbookinghotel' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' =>array(
                    'style1' => 'Style 1',
                    'style2' => 'Style 2',
                    'style3' => 'Style 3',
                ),
            ]
        );
        $this->add_control(
            'title_block',
            [
                'label' => __('Title block', 'wpbookinghotel'),
                'type' => Controls_Manager::TEXT,
                'default' => 'Why Choose Us',
            ]
        );
        $this->add_control(
            'title_block_review',
            [
                'label' => __('Title block review', 'wpbookinghotel'),
                'type' => Controls_Manager::TEXT,
                'default' => 'Top Review',
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => __( 'Description', 'wpbookinghotel' ),
                'type' => Controls_Manager::WYSIWYG,
                'default' => '',
            ]
        );
        $this->add_control(
            'limit',
            [
                'label' => __( 'Limit', 'wpbookinghotel' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
            ]
        );
        $this->end_controls_section();
    }
    public function get_script_depends() {
        return [ 'wpbookinghotel' ];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */


    public function get_data_config($settings) {
        $data_setting=new \stdClass();
        $data_setting->title_block = $settings['title_block'];
        $data_setting->title_block_review = $settings['title_block_review'];
        $data_setting->description = $settings['description'];
        $data_setting->style = $settings['style'];
        $data_setting->limit = $settings['limit'];
        return $data_setting;
    }
}
