<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;

$doc= Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('fontawesome');
WpBookingHotelHtmlFrontend::load_jquery_library('slick');
$doc->addLessStyleSheet('frontend/blocks/block_top_reviews/assets/less/block_top_reviews.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');


$params=$this->item->params;
$title_block=$params->get('title_block','');
$description=$params->get('description','');
$title_block_review=$params->get('title_block_review','');
$limit = $params->get('limit');
?>

<div class="block-top-reviews">
    <div class="row">
        <div class="col-md-6">
            <div class="choose-us">
                <h3><?php echo (esc_html($title_block))?></h3>
                <div class="content-left">
                    <div class="description">
                     <span><?php echo (html_entity_decode(esc_html($description)))?></span>
                    </div>
                    <div class="btn-read-more">
                        <button type="button" class="btn btn-primary"><?php esc_html_e('READ MORE','wpbookinghotel')?></button>
                    </div>
                </div>
            </div>

        </div>
        <div class="col-md-6">
            <div class="top-reviews">
                <div class="title">
                    <h3><?php echo esc_html($title_block_review)?></h3>
                    <div class="block-arrow">
                        <a href="" class="prev-arrow">
                            <i class="fas fa-long-arrow-alt-left"></i>
                        </a>
                        <a href="" class="next-arrow">
                            <i class="fas fa-long-arrow-alt-right"></i>
                        </a>
                    </div>
                </div>

                <div class="content">
                    <?php
                    foreach ($list_reviews as $review){
                        ?>
                        <?php
                        $max_star = 5;
                        $review_rating=$review->rating;

                        while ($review_rating > $max_star) {
                            $review_rating = $review_rating - $max_star;
                        }

                        $star = $review_rating % 10;
                        $non_star = ($max_star - $review_rating) % 10;
                        $half_star = ceil($max_star-$star-$non_star);
                        ?>
                    <div class="content-reviews">
                        <div class="add-reviews">
                            <div class="address-hotel text-1">
                                    <i class="fas fa-map-marker-alt"></i>
                                    <span><?php esc_html_e($review->location->address);?></span>
                                </div>
                            <div class="block-rating">
                                <ul class="list-rating-star">
                                    <?php if($review_rating > 0) {?>
                                        <?php for ($i=0; $i <$star; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$half_star; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                        <?php }?>
                                        <?php for ($i=0; $i <$non_star; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    <?php } else {?>
                                        <?php for($i = 1; $i <= 5; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    <?php }?>
                                </ul>
                            </div>
                        </div>
                        <div class="comment">
                            <div class="img-comment">
                                <div>
                                    <img class="lazy" data-src="<?php echo (Factory::getRootUrlPlugin())?><?php echo(isset($review->image)?$review->image:'frontend/app/assets/images/no-image.jpg');?>"
                                         alt="<?php esc_html_e($review->name);?>">
                                </div>
                            </div>
                            <div class="content-comment" title="<?php echo (esc_attr($review->comments));?>">
                                <?php echo ('"'.$review->comments.'"');?>
                            </div>

                        </div>
                        <div class="name">- <?php esc_html_e($review->name);?> -</div>
                    </div>

                    <?php }?>
                </div>


            </div>

        </div>
    </div>
</div>
<?php
$doc->addScriptApplySelector('.block-top-reviews','block_top_reviews',array(

),'frontend/blocks/block_top_reviews/assets/js/block_top_reviews.js');
?>