<?php

namespace WpBookingHotelBlock\block_top_reviews;

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;

class block_top_reviews_helper
{
    public static function getListReviews($limit)
    {
        $db = Factory::getDBO();
        $query = $db->getQuery(true);
        $query->select('review.*')
            ->from(UtilityAlias::getTableName('review') . ' AS review')
            ->where('review.published=1')
            ->where('review.rating >= 3');
        $list = $db->setQuery($query,0,$limit)->loadObjectList();
        foreach ($list as $review) {
            $query->clear()
                ->select('DISTINCT hotel_property.hotel_id')
                ->from(UtilityAlias::getTableName('hotelproperty').' AS hotel_property')
                ->where('hotel_property.type='.$query->quote(FrontendHelper::getWpBookingReviewKey()))
                ->where('hotel_property.object_id ='.(int)$review->id)
            ;
            $review->hotel_id=$db->setQuery($query)->loadResult();
            $query->clear()
                ->select('DISTINCT location.*')
                ->from(UtilityAlias::getTableName('location') . ' AS location')
                ->leftJoin(UtilityAlias::getTableName('hotelproperty') . ' AS hotelproperty ON hotelproperty.object_id=location.id')
                ->where('hotelproperty.hotel_id='.(int)$review->hotel_id)
                ->where(('hotelproperty.type='.$query->quote(FrontendHelper::getWpBookingDestinationKey())))

            ;
            $location = $db->setQuery($query)->loadObject();
            $review->location = $location;


        }

        return $list;
    }
}