<?php
namespace WpBookingHotelBlock\block_top_destinations_hotel;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Wordpress\TBPRO_Widget_Base;
use WpBookingHotel\Wordpress\TBPRO_Widget_Base_Interface;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Class CategoriesWidget
 */
class top_destinations_hotelWidget  extends TBPRO_Widget_Base
{

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }
    public function get_name() {

        return  "top_destinations_hotel";
    }
    public function get_title() {

        return  "Top Destinations Hotel";
    }
    protected function _register_controls() {
        $modelCountries=Model::getInstance('countries');
        $list_country=$modelCountries->getListCountryLocationPopular();
        $option=array();
        $option[0]= esc_html('Select country', 'wpbookinghotel' );

        foreach ($list_country as $country){
            $option[$country->id]= esc_html( $country->countryname );
        }
        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_attr('Content', 'WpBookingHotel' ),
            ]
        );
        $this->add_control(
            'style',
            [
                'label' => __( 'Style', 'wpbookinghotel' ),
                'type' => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' =>array(
                    'style1' => 'Style 1',
                    'style2' => 'Style 2',
                ),
            ]
        );
        $this->add_control(
            'filter_by_country',
            [
                'label' => __( 'Filter by country', 'wpbookinghotel' ),
                'type' => Controls_Manager::SELECT2,
                'multiple'=>'multiple',
                'default' => 0,
                'options' =>$option,
                'selectors' => [
                    '{{WRAPPER}} .country' => 'country: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'title_block',
        [
            'label' => __( 'Title block', 'wpbookinghotel' ),
            'type' => Controls_Manager::TEXT,
            'default' => 'Top destination hotel',
        ]
        );
        $this->add_control(
            'description',
            [
                'label' => __( 'Description', 'wpbookinghotel' ),
                'type' => Controls_Manager::TEXTAREA,
                'default' => '',
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_attr('Style', 'WpBookingHotel' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->end_controls_section();


    }



    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends() {
        return [ 'wpbookinghotel' ];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    public function get_data_config($settings) {
        $data_setting=new \stdClass();
        $data_setting->filter_by_country = $settings['filter_by_country'];
        $data_setting->title_block = $settings['title_block'];
        $data_setting->description = $settings['description'];
        $data_setting->style = $settings['style'];
        return $data_setting;
    }
}
