<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotelFrontend\app\helpers\ConfigHelper;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;

$doc= Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('fontawesome');
WpBookingHotelHtmlFrontend::load_jquery_library('slick');
$doc->addLessStyleSheet('frontend/blocks/block_top_destinations_hotel/assets/less/block_top_destinations_hotel.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');

if(!empty($list_location) && count($list_location) > 2) {
    $first_item_location = $list_location['0'];
    $second_item_location = $list_location['1'];
    unset($list_location['0']);
    unset($list_location['1']);
} else {
    $first_item_location = array();
    $second_item_location = array();
}

$page_hotel_list= ConfigHelper::get_page_list_hotel();
if($page_hotel_list) {
    $this->page_hotel_list = get_page_link($page_hotel_list);
}else{
    $this->page_hotel_list="";
}
$total_number_hotel = function ($list_location=array()){
    $number_hotel=0;
    foreach ($list_location as $location) {
        $number_hotel += isset($location->number_hotel)?$location->number_hotel:0;
    }
    return $number_hotel;
};
$params=$this->item->params;
$title_block=$params->get('title_block','');
$description=$params->get('description','');

?>
<div class="block-top-destinations-hotel">
    <div class="title">
        <h3><?php echo (esc_html($title_block))?></h3>
        <span><?php echo (esc_html($description))?></span>
    </div>
    <div class="box-hotel">
        <div class="box-hotel-top">
            <div class="row">
                <?php if(!empty($first_item_location)) {?>
                    <div class="col-md-5 col-sm-6">
                        <a href="<?php echo($this->page_hotel_list.'?country_id='.$first_item_location->id);?>">
                            <div class="block-location">
                                <div class="img-block img-1">
                                    <div>
                                        <img class="lazy" data-src="<?php echo(Factory::getRootUrlPlugin()) ?><?php echo((isset($first_item_location->gallery) && !empty($first_item_location->gallery)) ? reset($first_item_location->gallery)->path : ''); ?>"
                                             alt="<?php echo (isset($first_item_location->name) ? $first_item_location->name : ''); ?>">
                                    </div>
                                </div>
                                <div class="block-content">
                                    <div class="country-name">
                                        <h2 class="name">
                                            <i class="fas fa-thumbtack"></i>
                                            <span><?php echo (isset($first_item_location->countryname) ? $first_item_location->countryname : '') ?></span>
                                        </h2>

                                        <p class="quality">
                                            <span><?php echo ((isset($first_item_location->list_location) && !empty($first_item_location->list_location)) ? $total_number_hotel($first_item_location->list_location) : 0); ?>
                                                +</span> <span><?php esc_html_e('Hotels', 'wpbookinghotel') ?></span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php }?>
                <?php if(!empty($second_item_location)) {?>
                    <div class="col-md-7 col-sm-6">
                        <a href="<?php echo($this->page_hotel_list.'?country_id='.$second_item_location->id);?>">
                            <div class="block-location">
                                <div class="img-block img-2">
                                    <div>
                                        <img class="lazy" data-src="<?php echo(Factory::getRootUrlPlugin()) ?><?php echo ((isset($second_item_location->gallery) && !empty($second_item_location->gallery)) ? reset($second_item_location->gallery)->path: ''); ?>"
                                             alt="<?php echo (isset($second_item_location->name) ? $second_item_location->name : ''); ?>">
                                    </div>
                                </div>
                                <div class="block-content">
                                    <div class="country-name">
                                        <h2 class="name">
                                            <i class="fas fa-thumbtack"></i>
                                            <span><?php echo (isset($second_item_location->countryname) ? $second_item_location->countryname : '') ?></span>
                                        </h2>

                                        <p class="quality">
                                            <span><?php echo ((isset($second_item_location->list_location) && !empty($second_item_location->list_location)) ? $total_number_hotel($second_item_location->list_location) : 0); ?>
                                                +</span> <span><?php esc_html_e('Hotels', 'wpbookinghotel') ?></span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php }?>
            </div>
        </div>
        <div class="box-hotel-bottom">
            <div class="row">
                <?php foreach ($list_location as $location){ ?>
                <div class="col-md-3 col-sm-6">
                    <a href="<?php echo($this->page_hotel_list.'?country_id='.$location->id);?>">
                        <div class="block-location">
                            <div class="img-block">
                                <div>
                                    <img class="lazy" data-src="<?php echo(Factory::getRootUrlPlugin()) ?><?php echo ((isset($location->gallery) && !empty($location->gallery)) ? reset($location->gallery)->path : ''); ?>"
                                         alt="<?php echo (isset($location->name) ? $location->name : ''); ?>">
                                </div>
                            </div>
                            <div class="block-content">
                                <div class="country-name">
                                    <h2 class="name">
                                        <i class="fas fa-thumbtack"></i>
                                        <span><?php echo (isset($location->countryname) ? $location->countryname : '') ?></span>
                                    </h2>

                                    <p class="quality">
                                        <span><?php echo ((isset($location->list_location) && !empty($location->list_location))? $total_number_hotel($location->list_location) : 0); ?>
                                            +</span> <span><?php esc_html_e('Hotels', 'wpbookinghotel') ?></span>
                                    </p>
                                </div>
                            </div>

                        </div>
                    </a>
                </div>
                <?php } ?>
            </div>
        </div>
        <div class="btn-view-all">
            <a class="btn btn-primary" href="<?php echo (esc_attr($this->page_hotel_list));?>"><?php esc_html_e('View all','wpbookinghotel');?></a>
        </div>
    </div>
</div>
<?php
$doc->addScriptApplySelector('.block-top-destinations-hotel','block_top_destinations_hotel',array(

),'frontend/blocks/block_top_destinations_hotel/assets/js/block_top_destinations_hotel.js');
?>
