<?php

use WpBookingHotel\Language\Text;
use WpBookingHotelFrontend\app\helpers\ConfigHelper;
$doc->addLessStyleSheet('frontend/blocks/block_search_hotel/assets/less/block_search_hotel.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');

$page_hotel_list= ConfigHelper::get_page_list_hotel();
if($page_hotel_list) {
    $this->page_hotel_list = get_page_link($page_hotel_list);
}else{
    $this->page_hotel_list="";
}

?>

<div class="block-search-hotel">
    <form action="<?php echo (esc_attr($this->page_hotel_list))?>" class="form-search-hotel" method="post">
        <div class="box-search">
            <div class="map">
                <?php
                $field = $form_search_block->getField('keyword_address');
                echo($field->input);
                ?>
            </div>
            <div class="date-before">
                <?php
                    $field = $form_search_block->getField('check_in');
                    echo($field->input);
                ?>
            </div>
            <div class="date-after">
                <?php
                $field = $form_search_block->getField('check_out');
                echo($field->input);
                ?>
            </div>
            <div class="quality">
                <?php
                $field = $form_search_block->getField('total_person');
                echo($field->input);
                ?>
            </div>
            <div class="btn-search">
                <button type="submit" class="btn btn-primary"><?php esc_html_e('Search','wpbookinghotel')?></button>
            </div>
        </div>
    </form>

</div>
<?php
$doc->addScriptApplySelector('.block-search-hotel','block_search_hotel',array(),'frontend/blocks/block_search_hotel/assets/js/block_search_hotel.js');
?>

