"use strict";
(function ($) {
    $.block_search_hotel = function (element, options) {
        let defaults = {
          
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find(".map").prepend('<i class="fas fa-map-marker-alt"></i>');
            $element.find('input[id="check-in"]').on('change', function () {
                let date = moment($element.find('input[id="check-in"]').val(), "YYYY-MM-DD").add(1, 'd');
                $element.find('input[id="check-out"]').data('daterangepicker').minDate = date;
                $element.find('input[id="check-out"]').data('daterangepicker').startDate = date;
                $element.find('input[id="check-out"]').val(date.format("YYYY-MM-DD"));
                $element.find('input[name="check_out"]').val(date.format("YYYY-MM-DD"));
            });
            $element.find('input[id="check-out"]').on('change', function () {
                let date = moment($element.find('input[id="check-out"]').val(), "YYYY-MM-DD").subtract(1, 'd');
                $element.find('input[id="check-in"]').data('daterangepicker').maxDate = date;
            });
        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_search_hotel = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_search_hotel')) {
                let plugin = new $.block_search_hotel(this, options);
                $(this).data('block_search_hotel', plugin);
            }
        });
    }
  
})(jQuery);
