<?php
namespace WpBookingHotelBlock\block_popular_hotel;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use WpBookingHotel\Wordpress\TBPRO_Widget_Base;
use WpBookingHotel\Wordpress\TBPRO_Widget_Base_Interface;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


/**
 * Class CategoriesWidget
 */
class popular_hotelWidget  extends TBPRO_Widget_Base
{

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-ticker';
    }
    public function get_name() {

        return  "popular_hotel";
    }
    public function get_title() {

        return  "Popular hotel";
    }



    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_attr('Content', 'WpBookingHotel'),
            ]
        );
        $this->add_control(
            'style',
            [
                'label' => __('Style', 'wpbookinghotel'),
                'type' => Controls_Manager::SELECT,
                'default' => 'style1',
                'options'=>array(
                    'style1'=> 'Style 1',
                    'style2'=> 'Style 2',
                )
            ]
        );
        $this->add_control(
            'title_block',
            [
                'label' => __('Title block', 'wpbookinghotel'),
                'type' => Controls_Manager::TEXT,
                'default' => 'Popular Hotel',
            ]
        );
        $this->add_control(
            'description',
            [
                'label' => __('Description', 'wpbookinghotel'),
                'type' => Controls_Manager::TEXT,
                'default' => '',
            ]
        );
        $this->add_control(
            'limit',
            [
                'label' => __('Limit', 'wpbookinghotel'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
            ]
        );
        $this->end_controls_section();
    }
    public function get_script_depends() {
        return [ 'wpbookinghotel' ];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */

    public function get_data_config($settings) {
        $data_setting=new \stdClass();
        $data_setting->title_block = $settings['title_block'];
        $data_setting->limit = $settings['limit'];
        $data_setting->description = $settings['description'];
        $data_setting->style = $settings['style'];
        return $data_setting;
    }
}
