"use strict";
(function ($) {
    $.block_popular_hotel = function (element, options) {
        let defaults = {
            row_state_template: ""
        };
        let plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let $block_arrow=$element.find(".block-arrow");
            $element.find('.slide').slick({
                infinite: true,
                slidesToShow: 3,
                slidesToScroll: 3,
                prevArrow: $block_arrow.find('.prev-arrow'),
                nextArrow: $block_arrow.find('.next-arrow'),
                responsive: [
                    {
                        breakpoint: 1199,
                        settings: {
                            slidesToShow: 3,
                            slidesToScroll: 3,
                            infinite: true,
                            dots: true
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 2,
                            slidesToScroll: 2
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 1,
                            slidesToScroll: 1,
                            dots: true,
                            arrows: false

                        }
                    }
                ]
            });
            $element.find('.heart').on('click',function(e){
                $(this).toggleClass('active');
                let $hotel_item = $(this).closest('.wishlist-item');
                let hotel_id = $hotel_item.data('hotel_id');
                let user_id = $hotel_item.data('user_id');
                let data = {
                    task: "wishlist.change_wishlist",
                    state: 1,
                    hotel_id: hotel_id,
                    user_id: user_id,
                };
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: wpbookinghotel_root_url + wpbookinghotel_api_task,
                    data: data,
                    type: "POST",
                    beforeSend: function () {

                    },
                    error: function (xhr) {
                        
                    },
                    complete: function () {
                        
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        console.log("response",response);
                    }
                });
            })
            

        };
        plugin.example_function = function () {
        }
        plugin.init();
    }
    $.fn.block_popular_hotel = function (options) {
        return this.each(function () {
            if (undefined == $(this).data('block_popular_hotel')) {
                let plugin = new $.block_popular_hotel(this, options);
                $(this).data('block_popular_hotel', plugin);
            }
        });
    }
    $('div.dropdown-menu').on('click', function(event){
        // The event won't be propagated up to the document NODE and
        // therefore delegated events won't be fired
        event.stopPropagation();
    });
})(jQuery);
