<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;
use WpBookingHotelFrontend\app\Html\HtmlFrontend;
$hotel = $this->item;


$curent_user_id=Factory::getUser()->id;

$list_review = isset($hotel->list_review)?$hotel->list_review:array();
if(!empty($list_review)) {
    $rating_sum = 0;
    foreach ($list_review as $review) {
        if(isset($review->rating)) {
            $rating_sum += $review->rating;
        }
    }
    $max_star = 5;
    $hotel_rating=$rating_sum / count($list_review);
    while ($hotel_rating > $max_star) {
        $hotel_rating = $hotel_rating - $max_star;
    }

    $star = $hotel_rating % 10;
    $non_star = ($max_star - $hotel_rating) % 10;
    $half_star = ceil($max_star-$star-$non_star);
}

?>

<div class="list-hotel list-1">
        <div class="row">
            <div class="col-md-4">
                <div class="block-content-left">
                    <div class="img-block">
                        <a href="<?php echo($this->page_hotel_detail.'?hotel_id='.$hotel->id); ?>" style="display: block">
                            <div class="wishlist-hover">
                                <img src="<?php echo(Factory::getRootUrlPlugin())?><?php echo (isset($hotel->image)?$hotel->image:'');?>"
                                    alt="<?php echo (isset($hotel->name)?$hotel->name:'');?>">
                            </div>
                        </a>
                        <div class="category-name-heart">
                            <span class="heart <?php echo in_array($curent_user_id,$hotel->user_wishlist) ? 'active':'' ?> ">
                                <i class="fas fa-heart"></i>
                            </span>
                        </div>
                    </div>
                    <div class="price">
                        <span><?php echo(FrontendHelper::format_currency(isset($hotel->price)?$hotel->price:0))?></span>
                        <span><?php esc_html_e('Night','wpbookinghotel');?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="content-description">
                    <div class="block-rating">
                        <ul class="list-rating-star">
                            <?php if(!empty($list_review)) {?>
                                <?php for ($i=0; $i <$star; $i++) {?>
                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                <?php }?>
                                <?php for ($i=0; $i <$half_star; $i++) {?>
                                    <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                <?php }?>
                                <?php for ($i=0; $i <$non_star; $i++) {?>
                                    <li class="item-star"><i class="far fa-star"></i></li>
                                <?php }?>
                            <?php } else {?>
                                <?php for($i = 1; $i <= 5; $i++) {?>
                                    <li class="item-star"><i class="far fa-star"></i></li>
                                <?php }?>
                            <?php }?>
                        </ul>
                        <div class="rating-review">
                            <span><?php esc_html_e(count($list_review));?></span>
                            <span><?php esc_attr_e('Reviews','wpbookinghotel');?></span>
                        </div>
                    </div>
                    <a href="<?php echo($this->page_hotel_detail.'?hotel_id='.$hotel->id); ?>" style="display: block">
                        <div class="name-hotel text-1">
                            <h4><?php echo (isset($hotel->name)?$hotel->name:'');?></h4>
                        </div>
                    </a>
                    <div class="address-hotel text-1">
                        <i class="fas fa-map-marker-alt"></i>
                        <span title="<?php echo (isset($hotel->destination)?$hotel->destination->address:'');?>">
                            <?php echo (isset($hotel->destination)?$hotel->destination->address:'');?>
                        </span>
                    </div>
                    <div class="description text-1">
                        <?php echo (isset($hotel->description)?$hotel->description:'');?>
                    </div>
                </div>
            </div>
        </div>
</div>