<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotelFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-hotels1.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
WpBookingHotelHtmlFrontend::load_jquery_library('datatables');
WpBookingHotelHtmlFrontend::load_jquery_library('moment');
WpBookingHotelHtmlFrontend::load_jquery_library('daterangepicker');
WpBookingHotelHtmlFrontend::load_jquery_library('fontawesome');
WpBookingHotelHtmlFrontend::load_jquery_library('ui');
WpBookingHotelHtmlFrontend::load_jquery_library('icheck');
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
WpBookingHotelHtmlFrontend::load_jquery_library('twbs_pagination');
$this->user=FactoryAlias::getUser();
$list_hotel  = $this->list;
$list_roomtype = $this->list_roomtype;
$one_star = array();
$two_star = array();
$three_star = array();
$four_star = array();
$five_star = array();

$this->user=FactoryAlias::getUser();

foreach ($list_hotel as $hotel) {
    if(isset($hotel->rating_avg)) {
        if($hotel->rating_avg > 0 && $hotel->rating_avg <= 1) {
            array_push($one_star, $hotel);
        } elseif($hotel->rating_avg > 1 && $hotel->rating_avg <= 2) {
            array_push($two_star, $hotel);
        } elseif($hotel->rating_avg > 2 && $hotel->rating_avg <= 3) {
            array_push($three_star, $hotel);
        } elseif($hotel->rating_avg > 3 && $hotel->rating_avg <= 4) {
            array_push($four_star, $hotel);
        } elseif($hotel->rating_avg > 4 && $hotel->rating_avg <= 5) {
            array_push($five_star, $hotel);
        }
    }
}

$page_hotel_detail= ConfigHelperAlias::get_page_hotel_detail();
if($page_hotel_detail) {
    $this->page_hotel_detail = get_page_link($page_hotel_detail);
}else{
    $this->page_hotel_detail="";
}

$page_hotel_list= ConfigHelperAlias::get_page_list_hotel();
if($page_hotel_list) {
    $this->page_hotel_list = get_page_link($page_hotel_list);
}else{
    $this->page_hotel_list="";
}

$render_hotel_grid = function (){
    ob_start();
    ?>
        <?php foreach ( $this->list as $hotel) {?>
            <div class="col-sm-6 col-md-4 hotel-render-item wishlist-item" data-hotel_id= "<?php echo $hotel->id ?>" data-user_id= "<?php echo $this->user->id ?>" >
                <?php
                $this->item = $hotel;
                echo ($this->loadTemplate('list_item'));
                ?>
            </div>
        <?php }?>
    <?php
    $content = ob_get_clean();
    return $content;
};

$render_hotel_list = function (){
    ob_start();
    ?>
        <?php foreach ($this->list as $hotel) {?>
            <?php
            $this->item = $hotel;
            ?>
            <div class="hotel-render-item wishlist-item" data-hotel_id= "<?php echo $hotel->id ?>" data-user_id= "<?php echo $this->user->id ?>" >
                <?php echo($this->loadTemplate('list_row_item'));?>
            </div>
        <?php }?>
    <?php
    $content = ob_get_clean();
    return $content;
};
$input = FactoryAlias::getInput();
$sort = $input->getString('key_sort', "a.ordering");
$direction = $input->getString('direction', "ASC");
$rating = $input->getString('rating','');
$roomtype_id = $input->getString('room_type_id','');
$keyword_address = $input->getString('keyword_address','');
$uri = FactoryAlias::getUri();
$style = $uri->getVar('style', 'grid');


?>
    <div class="view-list-hotels">
        <form action="<?php echo (esc_attr($this->page_hotel_list.($style!==''?'?style='.$style : '')));?>" method="post" name="filter-form">
            <div class="row">
                <div class="col-md-3">
                    <h4 class="title-left"><?php esc_html_e('Find Us','wpbookinghotel');?></h4>
                    <div class="content-left search-hotel">
                        <div class="find-us btn-map">
                            <input type="text" id="map" class="form-control" name="keyword_address" value="<?php echo (esc_attr($keyword_address))?>" placeholder="<?php esc_attr_e('Your Destination?','wpbookinghotel');?>" />
                            <i class="far fa-compass"></i>
                        </div>
                        <div class="find-us input-date">
                            <?php
                            $field = $this->form->getField('check_in');
                            echo ($field->input);
                            ?>
                        </div>
                        <div class="find-us input-date">
                            <?php
                            $field = $this->form->getField('check_out');
                            echo ($field->input);
                            ?>
                        </div>
                        <div class="find-us btn-quality">
                            <?php
                            $field = $this->form->getField('total_person');
                            echo ($field->input);
                            ?>
                        </div>
                    </div>
                    <div class="content-left srat-ratings">
                        <h4 class="title-left"><?php esc_html_e('Star Ratings', 'wpbookinghotel');?></h4>
                        <div class="block-filter-star">
                            <div class="item-star-filter">
                                <input type="checkbox" name="rating[]" id="five-star" value="[4,5]" <?php echo ($rating!='' && is_array($rating) && in_array('[4,5]',$rating)?'checked':'');?>>
                                <label for="five-star">
                                    <ul class="list-rating-star">
                                        <?php for($i = 1; $i <= 5; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <span class="number-hotel">
                                        <?php echo (esc_html(count($five_star)));?>
                                    </span>
                                </label>
                            </div>
                            <div class="item-star-filter">
                                <input type="checkbox" name="rating[]" id="four-star" value="[3,4]" <?php echo ($rating!='' && is_array($rating) && in_array('[3,4]',$rating)?'checked':'');?>>
                                <label for="four-star">
                                    <ul class="list-rating-star">
                                        <?php for($i = 1; $i <= 4; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <li class="item-star"><i class="far fa-star"></i></li>
                                    </ul>
                                    <span class="number-hotel">
                                        <?php echo (esc_html(count($four_star)));?>
                                    </span>
                                </label>
                            </div>
                            <div class="item-star-filter">
                                <input type="checkbox" name="rating[]" id="three-star" value="[2,3]" <?php echo ($rating!='' && is_array($rating) && in_array('[2,3]',$rating)?'checked':'');?>>
                                <label for="three-star">
                                    <ul class="list-rating-star">
                                        <?php for($i = 1; $i <= 3; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for($i = 1; $i <= 2; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <span class="number-hotel">
                                        <?php echo (esc_html(count($three_star)));?>
                                    </span>
                                </label>
                            </div>
                            <div class="item-star-filter">
                                <input type="checkbox" name="rating[]" id="two-star" value="[1,2]" <?php echo ($rating!='' && is_array($rating) && in_array('[1,2]',$rating)?'checked':'');?>>
                                <label for="two-star">
                                    <ul class="list-rating-star">
                                        <?php for($i = 1; $i <= 2; $i++) {?>
                                            <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php }?>
                                        <?php for($i = 1; $i <= 3; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <span class="number-hotel">
                                        <?php echo (esc_html(count($two_star)));?>
                                    </span>
                                </label>
                            </div>
                            <div class="item-star-filter">
                                <input type="checkbox" name="rating[]" id="one-star" value="[0,1]" <?php echo ($rating!='' && is_array($rating) && in_array('[0,1]',$rating)?'checked':'');?>>
                                <label for="one-star">
                                    <ul class="list-rating-star">
                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                        <?php for($i = 1; $i <= 4; $i++) {?>
                                            <li class="item-star"><i class="far fa-star"></i></li>
                                        <?php }?>
                                    </ul>
                                    <span class="number-hotel">
                                        <?php echo (esc_html(count($one_star)));?>
                                    </span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="content-left rooms-types ">
                        <h4 class="title-left"><?php esc_html_e('Rooms Types','wpbookinghotel');?></h4>
                        <div class="block-filter-roomtype">
                            <?php foreach ($list_roomtype as $roomtype) {?>
                                <div class="item-filter-roomtype">
                                    <input type="checkbox" name="room_type_id[]" id="roomtype-<?php echo (esc_attr($roomtype->id));?>"  value="<?php echo (esc_attr($roomtype->id));?>" <?php echo($roomtype_id!='' && is_array($roomtype_id) && in_array($roomtype->id,$roomtype_id)?'checked':'');?>>
                                    <label for="roomtype-<?php echo (esc_attr($roomtype->id));?>">
                                        <?php esc_html_e($roomtype->name,'wpbookinghotel');?>
                                    </label>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="btn-search">
                        <button type="submit" class="btn btn-primary"><?php esc_html_e('Search','wpbookinghotel');?></button>
                    </div>
                </div>
                <div class="col-md-9">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="wrapper-hotel">
                                <div class="option-hotel">
                                    <div class="sort-by-block">
                                        <div class="dropdown">
                                            <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:void(0)">
                                                <span class="select-by-default"><?php esc_attr_e('Sort by', 'wpbookinghotel') ?></span>
                                                <i class="fas fa-chevron-down"></i>
                                            </a>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <ul class="sort-display">
                                                    <li class="<?php echo ($sort=="a.name" && $direction=="ASC"?' active ':'') ?>"><a  class="select-sort-item <?php echo ($sort=="a.name" && $direction=="ASC"?' active ':'') ?>" data-key_sort="a.name" data-direction="ASC"  href="javascript:void(0)"><?php esc_attr_e('Sort by name from A-Z', 'wpbookinghotel') ?></i></a></li>
                                                    <li class="<?php echo ($sort=="a.name" && $direction=="DESC"?' active ':'') ?>"><a class="select-sort-item <?php echo ($sort=="a.name" && $direction=="DESC"?' active ':'') ?>" data-key_sort="a.name" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Sort by name from Z-A', 'wpbookinghotel') ?></a></li>
                                                    <li class="<?php echo ($sort=="a.price" && $direction=="ASC"?' active ':'') ?>"><a class="select-sort-item <?php echo ($sort=="a.price" && $direction=="ASC"?' active ':'') ?>" data-key_sort="a.price" data-direction="ASC"   href="javascript:void(0)"><?php esc_attr_e('Sort by ascending price', 'wpbookinghotel') ?></a></li>
                                                    <li class="<?php echo ($sort=="a.price" && $direction=="DESC"?' active ':'') ?>"><a class="select-sort-item <?php echo ($sort=="a.price" && $direction=="DESC"?' active ':'') ?>" data-key_sort="a.price" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Sort by descending price', 'wpbookinghotel') ?></a></li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="nav nav-tabs menu-display">
                                        <li class="<?php echo (esc_attr($style=='grid'?'active':''))?>"><a data-toggle="tab" href="#home"><i class="fas fa-th-large"></i></a></li>
                                        <li class="<?php echo (esc_attr($style=='list'?'active':''))?>"><a data-toggle="tab" href="#menu1"><i class="fas fa-list"></i></a></li>
                                    </ul>
                                </div>
                                <div class="content-right">
                                    <div class="show">
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="tab-content">
                                <div id="home" class="tab-pane fade <?php echo (esc_attr($style=='grid'?'in active':''))?>">
                                    <?php if(count($list_hotel) > 0) {?>
                                        <div class="row wrapper-hotel-grid"></div>
                                    <?php } else {?>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="alert-block">
                                                    <span><?php esc_attr_e('Could not found any hotels','wpbookinghotel')?></span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php }?>
                                </div>
                                <div id="menu1" class="tab-pane fade <?php echo (esc_attr($style=='list'?'in active':''))?>">
                                    <?php if(count($list_hotel) > 0) {?>
                                        <div class="wrapper-hotel-list"></div>
                                    <?php } else {?>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="alert-block">
                                                    <span><?php esc_attr_e('Could not found any hotels','wpbookinghotel')?></span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php }?>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="pagination-hotel"></ul>
                        </div>
                    </div>
                </div>

            </div>
            <input type="hidden" name="key_sort" value="<?php echo (esc_attr($sort)) ?>">
            <input type="hidden" name="direction" value="<?php echo (esc_attr($direction)) ?>">
        </form>
    </div>

<?php
$doc->addScriptApplySelector('.view-list-hotels', 'view_list_hotels', array(
    'data_input' => '',
    'render_hotel_list'=>$render_hotel_list(),
    'render_hotel_grid'=>$render_hotel_grid()
), "frontend/app/assets/js/view_list_hotels.js");
?>