<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotelFrontend\app\Html\HtmlFrontend;
use WpBookingHotelFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

$doc = FactoryAlias::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-services.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
WpBookingHotelHtmlFrontend::load_jquery_library('datatables');
WpBookingHotelHtmlFrontend::load_jquery_library('moment');
WpBookingHotelHtmlFrontend::load_jquery_library('daterangepicker');
WpBookingHotelHtmlFrontend::load_jquery_library('fontawesome');
WpBookingHotelHtmlFrontend::load_jquery_library('ui');
WpBookingHotelHtmlFrontend::load_jquery_library('icheck');
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
WpBookingHotelHtmlFrontend::load_jquery_library('loading_js');
WpBookingHotelHtmlFrontend::load_jquery_library('confirm');
WpBookingHotelHtmlFrontend::load_jquery_library('store_locator_js');
WpBookingHotelHtmlFrontend::load_jquery_library('twbs_pagination');

$current_user_id = isset(FactoryAlias::getUser()->id) ? FactoryAlias::getUser()->id :'0';

$list_roomtype = $this->list_roomtype;
$one_star = array();
$two_star = array();
$three_star = array();
$four_star = array();
$five_star = array();
$uri = FactoryAlias::getUri();
$style = $uri->getVar('style', '');
$layout = $uri->getVar('layout', '');

if($layout==''){
    $options = hotelier_get_options('nbcore_listing_with_sidebar');
    if ($options==1){
        $layout = 'sidebar';
    }
    elseif($options==''){
        $layout='fullwidth';
    }
}
else{
    if ($layout=='sidebar'){
        $options = 1;
    }
    elseif($layout=='fullwidth'){
        $options = "";
    }
}
$page_service_detail = ConfigHelperAlias::get_page_hotel_detail();
if ($page_service_detail) {
    $this->page_service_detail = get_page_link($page_service_detail);
} else {
    $this->page_service_detail = "";
}
$number_service = count($this->list);
$page_list_service = ConfigHelperAlias::get_page_list_hotel();
if ($page_list_service) {
    $page_list_service = get_page_link($page_list_service);
} else {
    $page_list_service = "";
}

$input = FactoryAlias::getInput();
$sort = $input->getString('key_sort', "a.ordering");
$direction = $input->getString('direction', "ASC");
$rating = $input->getString('rating','');
if( $rating != '' ) {
    $arr = str_replace(']','',$rating);
    $arr = str_replace('[','',$arr);
    $rating = array_values(array_unique(explode(',', $arr)));
}
$roomtype_id = $input->getString('room_type_id','');
$keyword_address = $input->getString('keyword_address','');
$page = $input->getString('page', 1);
$uri = FactoryAlias::getUri();
$style = $uri->getVar('style', 'grid');
$tab = $input->getString('tab', "grid");
$start = $input->getInt('start', 0);
$limit = $input->getInt('limit', 1);
$user_id = isset(FactoryAlias::getUser()->id)?FactoryAlias::getUser()->id:0;
?>

    <div class="view-list-servicelocator view-list-hotels" data-user_id='<?php echo $current_user_id?>'>
        <form action="" method="post" name="filter-form" id="bh-sl-user-location" class="form-search-service form-search-hotels">
            <div class="row">
                <div class="col-md-12">
                    <div class="bh-sl-container">
                        <div id="bh-sl-map-container" class="bh-sl-map-container">
                            <div class="row">
                                <div class="col-md-6 height-list">
                                    <div class="wrap-list">
                                        <div class="wrap-filter">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <h4 class="title-left"><?php esc_html_e('Find Us','hotelier');?></h4>
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="content-left search-hotel">
                                                                <div class="row">
                                                                    <div class="find-us col-lg-6 btn-map">
                                                                        <input type="text" id="map" class="form-control" name="keyword_address" value="<?php echo (esc_attr($keyword_address))?>" placeholder="<?php esc_attr_e('Your Destination?','hotelier');?>" />
                                                                        <i class="far fa-compass"></i>
                                                                    </div>
                                                                    <div class="find-us col-lg-6 input-date">
                                                                        <?php
                                                                        $field = $this->form->getField('check_in');
                                                                        echo (($field->input));
                                                                        ?>
                                                                    </div>
                                                                    <div class="find-us col-lg-6 input-date">
                                                                        <?php
                                                                        $field = $this->form->getField('check_out');
                                                                        echo (($field->input));
                                                                        ?>
                                                                    </div>
                                                                    <div class="find-us col-lg-6 btn-quality">
                                                                        <?php
                                                                        $field = $this->form->getField('total_person');
                                                                        echo (($field->input));
                                                                        ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <h4 class="title-left title-load-more"><span class="icon-plush"></span> <?php esc_html_e('Advance Option','hotelier');?></h4>
                                                            <div class="advance-option block-filter-load-more">
                                                                <h4 class="title-left"><?php esc_html_e('Star Ratings','hotelier');?></h4>
                                                                <div class="content-left srat-ratings">
                                                                    <div class="block-filter-star">
                                                                        <div class="item-star-filter">
                                                                            <input type="checkbox" name="rating[]" id="five-star" value="[4,5]" <?php echo esc_attr(!empty($rating) && is_array($rating) && ( in_array(4,$rating) && in_array(5,$rating) )?'checked':'');?>>
                                                                            <label for="five-star">
                                                                                <ul class="list-rating-star">
                                                                                    <?php for($i = 1; $i <= 5; $i++) {?>
                                                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                                                    <?php }?>
                                                                                </ul>
                                                                                <span class="number-hotel">
                                                                                    <?php echo (esc_html(count($five_star)));?>
                                                                                </span>
                                                                            </label>
                                                                        </div>
                                                                        <div class="item-star-filter">
                                                                            <input type="checkbox" name="rating[]" id="four-star" value="[3,4]" <?php echo esc_attr(!empty($rating) && is_array($rating) && ( in_array(3,$rating) && in_array(4,$rating) )?'checked':'');?>>
                                                                            <label for="four-star">
                                                                                <ul class="list-rating-star">
                                                                                    <?php for($i = 1; $i <= 4; $i++) {?>
                                                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                                                    <?php }?>
                                                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                                                </ul>
                                                                                <span class="number-hotel">
                                                                            <?php echo (esc_html(count($four_star)));?>
                                                                        </span>
                                                                            </label>
                                                                        </div>
                                                                        <div class="item-star-filter">
                                                                            <input type="checkbox" name="rating[]" id="three-star" value="[2,3]" <?php echo esc_attr(!empty($rating) && is_array($rating) && ( in_array(2,$rating) && in_array(3,$rating) )?'checked':'');?>>
                                                                            <label for="three-star">
                                                                                <ul class="list-rating-star">
                                                                                    <?php for($i = 1; $i <= 3; $i++) {?>
                                                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                                                    <?php }?>
                                                                                    <?php for($i = 1; $i <= 2; $i++) {?>
                                                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                                                    <?php }?>
                                                                                </ul>
                                                                                <span class="number-hotel">
                                                                                    <?php echo (esc_html(count($three_star)));?>
                                                                                </span>
                                                                            </label>
                                                                        </div>
                                                                        <div class="item-star-filter">
                                                                            <input type="checkbox" name="rating[]" id="two-star" value="[1,2]" <?php echo esc_attr(!empty($rating) && is_array($rating) && ( in_array(1,$rating) && in_array(2,$rating) )?'checked':'');?>>
                                                                            <label for="two-star">
                                                                                <ul class="list-rating-star">
                                                                                    <?php for($i = 1; $i <= 2; $i++) {?>
                                                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                                                    <?php }?>
                                                                                    <?php for($i = 1; $i <= 3; $i++) {?>
                                                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                                                    <?php }?>
                                                                                </ul>
                                                                                <span class="number-hotel">
                                                                                    <?php echo (esc_html(count($two_star)));?>
                                                                                </span>
                                                                            </label>
                                                                        </div>
                                                                        <div class="item-star-filter">
                                                                            <input type="checkbox" name="rating[]" id="one-star" value="[0,1]" <?php echo esc_attr(!empty($rating) && is_array($rating) && ( in_array(0,$rating) && in_array(1,$rating) )?'checked':'');?>>
                                                                            <label for="one-star">
                                                                                <ul class="list-rating-star">
                                                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                                                    <?php for($i = 1; $i <= 4; $i++) {?>
                                                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                                                    <?php }?>
                                                                                </ul>
                                                                                <span class="number-hotel">
                                                                                    <?php echo (esc_html(count($one_star)));?>
                                                                                </span>
                                                                            </label>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <h4 class="title-left"><?php esc_html_e('Rooms Types','hotelier');?></h4>
                                                                <div class="content-left rooms-types ">
                                                                    <div class="block-filter-roomtype">
                                                                        <?php foreach ($list_roomtype as $roomtype) {?>
                                                                            <div class="item-filter-roomtype">
                                                                                <input type="checkbox" name="room_type_id[]" id="roomtype-<?php echo esc_attr($roomtype->id);?>"  value="<?php echo esc_attr($roomtype->id);?>" <?php echo esc_attr($roomtype_id!='' && is_array($roomtype_id) && in_array($roomtype->id,$roomtype_id)?'checked':'');?>>
                                                                                <label for="roomtype-<?php echo (esc_attr($roomtype->id));?>">
                                                                                    <?php echo esc_html($roomtype->name);?>
                                                                                </label>
                                                                            </div>
                                                                        <?php } ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="wrapper-content-left">
                                            <div class="wrap-above-hotel-list">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="wrapper-hotel">
                                                            <div class="option-hotel">
                                                                <div class="sort-by-block">
                                                                    <div class="dropdown">
                                                                        <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:void(0)">
                                                                            <span class="select-by-default"><?php esc_attr_e('Sort by', 'hotelier') ?></span>
                                                                            <i class="fas fa-chevron-down"></i>
                                                                        </a>
                                                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                                            <ul class="sort-display">
                                                                                <li class="<?php echo esc_attr($sort=="a.name" && $direction=="ASC"?' active ':'') ?>"><a  class="select-sort-item <?php echo esc_attr($sort=="a.name" && $direction=="ASC"?' active ':'') ?>" data-key_sort="a.name" data-direction="ASC" href="javascript:void(0)"><?php esc_attr_e('Sort by name from A-Z', 'hotelier') ?></i></a></li>
                                                                                <li class="<?php echo esc_attr($sort=="a.name" && $direction=="DESC"?' active ':'') ?>"><a class="select-sort-item <?php echo esc_attr($sort=="a.name" && $direction=="DESC"?' active ':'') ?>" data-key_sort="a.name" data-direction="DESC" href="javascript:void(0)"><?php esc_attr_e('Sort by name from Z-A', 'hotelier') ?></a></li>
                                                                                <li class="<?php echo esc_attr($sort=="a.price" && $direction=="ASC"?' active ':'') ?>"><a class="select-sort-item <?php echo esc_attr($sort=="a.price" && $direction=="ASC"?' active ':'') ?>" data-key_sort="a.price" data-direction="ASC" href="javascript:void(0)"><?php esc_attr_e('Sort by ascending price', 'hotelier') ?></a></li>
                                                                                <li class="<?php echo esc_attr($sort=="a.price" && $direction=="DESC"?' active ':'') ?>"><a class="select-sort-item <?php echo esc_attr($sort=="a.price" && $direction=="DESC"?' active ':'') ?>" data-key_sort="a.price" data-direction="DESC" href="javascript:void(0)"><?php esc_attr_e('Sort by descending price', 'hotelier') ?></a></li>
                                                                            </ul>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <ul class="nav nav-tabs menu-display">
                                                                    <li data-layout="grid" class="<?php echo (esc_attr($style=='grid'?'active':''))?>"><a href="#grid-display"><i class="fas fa-th-large"></i></a></li>
                                                                    <li data-layout="list" class="<?php echo (esc_attr($style=='list'?'active':''))?>"><a href="#menu1"><i class="fas fa-list"></i></a></li>
                                                                </ul>
                                                            </div>
                                                            <div class="content-right">
                                                                <div class="showing"><span class="showing-start">Showing <span class="count0"></span> - </span><span class="count1"></span> of <span class="count2"><?php echo count($this->list) ?></span> results</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="tab-contents wrapper-result-body">
                                                <div id="grid-display" data-layout="grid" class="<?php echo (esc_attr($tab=='grid'?'in active':''))?>">
                                                    <div class="bh-sl-loc-grid wrapper-hotel-grid">
                                                        <div class="row grid">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div id="menu1" data-layout="list" class="<?php echo (esc_attr($tab=='list'?'in active':''))?>">
                                                    <div class="bh-sl-loc-list">
                                                        <div class="list">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 sticky-map">
                                    <div id="bh-sl-map" class="bh-sl-map"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row footer-end">
                <div class="col-lg-6">
                    <div class="bh-sl-pagination-container">
                        <ol class="bh-sl-pagination">

                        </ol>
                    </div>
                </div>
            </div>
            <input type="hidden" name="start" value="<?php echo $start ?>">
            <input type="hidden" name="limit" value="12">
            <input type="hidden" name="limit1" value="12">
            <input type="hidden" name="total_item" value="<?php echo $this->total_item ?>">
            <input type="hidden" name="tab" value="<?php echo $tab ?>">
            <input type="hidden" name="page" value="<?php echo $page ?>">
            <input type="hidden" name="key_sort" value="<?php echo (esc_attr($sort)) ?>">
            <input type="hidden" name="direction" value="<?php echo (esc_attr($direction)) ?>">
            <input type="hidden" name="layout" value="<?php echo $layout ?>">
            <input type="hidden" name="user_id" value="<?php echo $user_id ?>">
        </form>
    </div>
<?php
$input = FactoryAlias::getInput();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-servicelocator.less');
$doc->addScriptApplySelector('.view-list-servicelocator', 'view_list_servicelocator', array(
    'data_input' => $input->getData(),
    'list_service'=>$this->list,
    "limit" => $limit,
    "start" => $start,
    "page" => $page,
    "store_limit" => $this->total_item
), "frontend/app/assets/js/view_list_servicelocator.js");
?>