<?php

use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;
use WpBookingHotelFrontend\app\Html\HtmlFrontend;
use WpBookingHotelFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

WpBookingHotelHtmlFrontend::load_jquery_library('slick');
WpBookingHotelHtmlFrontend::load_jquery_library('validate');
WpBookingHotelHtmlFrontend::load_jquery_library('confirm');

$doc = FactoryAlias::getDocument();
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addLessStyleSheet('frontend/app/assets/less/view-hotel-detail.less');
WpBookingHotelHtmlFrontend::load_jquery_library('datatables');
WpBookingHotelHtmlFrontend::load_jquery_library('moment');
WpBookingHotelHtmlFrontend::load_jquery_library('daterangepicker');
WpBookingHotelHtmlFrontend::load_jquery_library('fontawesome');
WpBookingHotelHtmlFrontend::load_jquery_library('ui');
WpBookingHotelHtmlFrontend::load_jquery_library('icheck');
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
WpBookingHotelHtmlFrontend::load_jquery_library('twbs_pagination');

$hotel = $this->item;

$gallery = isset($hotel->gallery)?$hotel->gallery:array();

$list_review = isset($hotel->list_review)?$hotel->list_review:array();

$one_star = array();
$two_star = array();
$three_star = array();
$four_star = array();
$five_star = array();
if(!empty($list_review)) {
    $rating_sum = 0;
    foreach ($list_review as $review) {
        if(isset($review->rating)) {
            $rating_sum += $review->rating;
        }
        if(isset($review->rating)) {
            if($review->rating > 0 && $review->rating <= 1) {
                array_push($one_star, $review);
            } elseif($review->rating > 1 && $review->rating <= 2) {
                array_push($two_star, $review);
            } elseif($review->rating > 2 && $review->rating <= 3) {
                array_push($three_star, $review);
            } elseif($review->rating > 3 && $review->rating <= 4) {
                array_push($four_star, $review);
            } elseif($review->rating > 4 && $review->rating <= 5) {
                array_push($five_star, $review);
            }
        }
    }
    $max_star = 5;
    $hotel_rating=$rating_sum / count($list_review);
    while ($hotel_rating > $max_star) {
        $hotel_rating = $hotel_rating - $max_star;
    }

    $star = $hotel_rating % 10;
    $non_star = ($max_star - $hotel_rating) % 10;
    $half_star = ceil($max_star-$star-$non_star);

}

$page_hotel_detail= ConfigHelperAlias::get_page_hotel_detail();
if($page_hotel_detail) {
    $this->page_hotel_detail = get_page_link($page_hotel_detail);
}else{
    $this->page_hotel_detail="";
}
$page_checkout_default= ConfigHelperAlias::get_page_checkout();
if($page_checkout_default) {
    $this->page_checkout_default = get_page_link($page_checkout_default);
}else{
    $this->page_checkout_default="";
}

$render_list_review = function ($list_review) {
    ob_start();
    ?>
        <?php if(!empty($list_review)) {?>
            <?php foreach ($list_review as $review) {?>
                <div class="comment-1 render-item-review">
                    <div class="image-reviewer">
                        <div>
                            <img src="<?php echo (esc_attr(FactoryAlias::getRootUrlPlugin().'frontend/app/assets/images/no-image.jpg'))?>">
                        </div>
                    </div>
                    <div class="info-review">
                        <div class="info-top">
                            <div class="reviewer-name">
                                <?php echo (esc_html($review->name));?>
                            </div>
                            <div class="datetime-review">
                                <span class="time-review"><?php echo(HtmlFrontend::render_date($review->created_date,'H:i A')) ?></span>
                                <span class="date-review"><?php echo(date('F d, Y',strtotime($review->created_date))) ?></span>
                            </div>
                            <?php
                            $max_star = 5;
                            $rating = $review->rating;
                            while ($rating > $max_star) {
                                $rating = $rating - $max_star;
                            }

                            $star = $rating % 10;
                            $non_star = ($max_star - $rating) % 10;
                            $half_star = ceil($max_star-$star-$non_star);
                            ?>
                            <ul class="list-rating-star">
                                <?php if($rating > 0) {?>
                                    <?php for ($i=0; $i <$star; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$half_star; $i++) {?>
                                        <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                    <?php }?>
                                    <?php for ($i=0; $i <$non_star; $i++) {?>
                                        <li class="item-star"><i class="far fa-star"></i></li>
                                    <?php }?>
                                <?php } else {?>
                                    <?php for($i = 1; $i <= 5; $i++) {?>
                                        <li class="item-star"><i class="far fa-star"></i></li>
                                    <?php }?>
                                <?php }?>
                            </ul>
                        </div>
                        <div class="content-review">
                            <span><?php esc_html_e($review->comments,'wpbookinghotel');?></span>
                        </div>
                    </div>
                </div>
            <?php }?>
        <?php }?>
    <?php
    $content = ob_get_clean();
    return $content;

}

?>
    <div class="view-hotel-detail">
        <div class="block-alert"></div>
        <div class="block-slide">
            <div class="gallery-slide">
                <?php if(!empty($gallery)) {?>
                    <?php foreach ($gallery as $image) {?>
                        <div class="img-block">
                            <div>
                                <img class="lazy" data-src="<?php echo (FactoryAlias::getRootUrlPlugin())?><?php echo (isset($image->path)?$image->path:'');?>" alt="<?php echo (isset($hotel->name)?$hotel->name:'');?>">
                            </div>
                        </div>
                    <?php }?>
                <?php }?>
            </div>
            <a href="javascript:void()" class="arrow-prev"><i class="fas fa-chevron-left"></i></a>
            <a href="javascript:void()" class="arrow-next"><i class="fas fa-chevron-right"></i></a>
        </div>
        <div class="row">
            <div class="col-md-9">
                <div class="content-left">
                    <div class="info-hotel">
                        <div class="name-hotel text-1">
                            <h4><?php echo (isset($hotel->name)?$hotel->name:'');?></h4>
                        </div>
                        <div class="block-group-address-rating">
                            <div class="address-hotel text-1">
                                <i class="fas fa-map-marker-alt"></i>
                                <span><?php echo (isset($hotel->destination)?$hotel->destination->address:'');?></span>
                            </div>
                            <div class="ratting-hotel text-1">
                                <div class="block-rating">
                                    <ul class="list-rating-star">
                                        <?php if(!empty($list_review)) {?>
                                            <?php for ($i=0; $i <$star; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$half_star; $i++) {?>
                                                <li class="item-star"><i class="fas fa-star-half-alt"></i></li>
                                            <?php }?>
                                            <?php for ($i=0; $i <$non_star; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        <?php } else {?>
                                            <?php for($i = 1; $i <= 5; $i++) {?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            <?php }?>
                                        <?php }?>
                                    </ul>
                                    <div class="rating-review">
                                        <span><?php echo (esc_html(count($list_review)));?></span>
                                        <span><?php esc_attr_e('Reviews','wpbookinghotel');?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="price-hotel text-1">
                            <span class="title"><?php esc_html_e('Start Form','wpbookinghotel');?> :</span>
                            <span class="price"><?php echo (FrontendHelper::format_currency(isset($hotel->price)?$hotel->price:0));?></span>
                            <span class="suffixes"><?php esc_html_e('Night','wpbookinghotel');?></span>
                        </div>
                        <div class="description-1">
                            <?php echo (isset($hotel->description)?$hotel->description:'');?>
                        </div>
                        <div class="note">
                            <div class="note-text">
                                <i class="fas fa-tags"></i>
                                <span>
                                    <?php echo (implode(',', array_map(
                                        function ($v) {
                                            return $v;
                                        }, isset($hotel->tag_name)?$hotel->tag_name:array()
                                    ))); ?>
                                </span>
                            </div>
                            <div class="btn-note">
                                <?php if($hotel->params->get('facebook')) {?>
                                    <a id="fb" class="link-social btn-web" href="<?php echo ($hotel->params->get('facebook'))?>"><i class="fab fa-facebook-f"></i></a>
                                <?php }?>
                                <?php if($hotel->params->get('twitter')) {?>
                                    <a id="twitter" class="link-social btn-web" href="<?php echo ($hotel->params->get('twitter'))?>"><i class="fab fa-twitter"></i></a>
                                <?php }?>
                                <?php if($hotel->params->get('linkedin')) {?>
                                    <a id="in" class="link-social btn-web" href="<?php echo ($hotel->params->get('linkedin'))?>"><i class="fab fa-linkedin-in"></i></a>
                                <?php }?>
                                <?php if($hotel->params->get('instagram')) {?>
                                    <a id="insta" class="link-social btn-web" href="<?php echo ($hotel->params->get('instagram'))?>"><i class="fab fa-instagram"></i></a>
                                <?php }?>
                            </div>

                        </div>
                        <div class="best-services">
                            <h4><?php esc_html_e('The Best Services','wpbookinghotel');?></h4>
                            <div class="content-service">
                                <div class="box-services">
                                    <?php if(isset($hotel->list_service) && !empty($hotel->list_service)) {?>
                                        <?php foreach ($hotel->list_service as $service) {?>
                                            <div class="block-item">
                                                <div class="img-service">
                                                    <div>
                                                        <img class="lazy" data-src="<?php echo (FactoryAlias::getRootUrlPlugin())?><?php echo (esc_attr($service->image));?>" alt="<?php echo (isset($service->name)?$service->name:'');?>">
                                                    </div>
                                                </div>
                                                <span><?php echo (isset($service->name)?$service->name:'');?></span>
                                            </div>
                                        <?php }?>
                                    <?php }?>
                                </div>
                            </div>
                        </div>
                        <div class="pricing-plan">
                            <h4><?php esc_html_e('Pricing Plans','wpbookinghotel');?></h4>
                            <div class="row">
                                <?php if(isset($hotel->list_roomtype) && !empty($hotel->list_roomtype)) {?>
                                    <?php foreach ($hotel->list_roomtype as $roomtype) {?>
                                        <div class="col-sm-6 col-md-4">
                                            <div class="box-room" data-roomtype_id="<?php echo (isset($roomtype->id)?$roomtype->id:'');?>">
                                                <div class="title-room">
                                                    <h4><?php echo (isset($roomtype->name)?$roomtype->name:'');?></h4>
                                                </div>
                                                <div class="img-block">
                                                    <div>
                                                        <img class="lazy" data-src="<?php echo (FactoryAlias::getRootUrlPlugin())?><?php echo(isset($roomtype->image)?$roomtype->image:'');?>"
                                                             alt="<?php echo (isset($roomtype->name)?$roomtype->name:'');?>">
                                                    </div>
                                                </div>
                                                <div class="detail-room room-2" title="<?php echo implode('&#013;',(array_map(function ($v) {return $v->name;},$roomtype->list_amenity)))?>">
                                                    <?php if (isset($roomtype->list_amenity) && !empty($roomtype->list_amenity)) {?>
                                                        <?php foreach ($roomtype->list_amenity as $amenity) {?>
                                                            <span><?php echo (isset($amenity->name) ? $amenity->name: '');?></span>
                                                        <?php }?>
                                                    <?php }?>
                                                </div>
                                                <div class="btn-book">
                                                    <button type="button" class="btn btn-dark btn-select-room-type"><?php esc_html_e('Book now','wpbookinghotel');?></button>
                                                </div>
                                                <div class="price">
                                                    <span><?php echo (FrontendHelper::format_currency(isset($roomtype->price_child) && isset($roomtype->price_adult)?min($roomtype->price_child,$roomtype->price_adult):0));?></span>
                                                    <span><?php esc_html_e('Night','wpbookinghotel');?></span>
                                                </div>
                                            </div>
                                        </div>
                                    <?php }?>
                                <?php }?>
                            </div>
                        </div>
                        <div class="hotel-location">
                            <h4><?php esc_html_e('Hotel Location','wpbookinghotel');?></h4>
                            <div class="hotel-map">
                                <?php echo(html_entity_decode(isset($hotel->destination->iframe)?$hotel->destination->iframe:''))?>
                            </div>
                        </div>
                        <div class="hotline">
                            <div class="toll-free">
                                <div class="icon"><i class="fas fa-phone-alt"></i></div>
                                <div class="content-toll">
                                    <div class="text">
                                        <?php esc_html_e('Toll Free','wpbookinghotel');?>
                                    </div>
                                    <div class="content">

                                        <?php
                                        if(  preg_match( '/(\d{3})(\d{3})(\d{4})$/', isset($hotel->phone_number)?$hotel->phone_number:'',  $matches ) )
                                        {
                                            $result = $matches[1] . ' ' .$matches[2] . ' ' . $matches[3];
                                            esc_html_e($result) ;
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>

                            <div class="email-us">
                                <div class="icon"><i class="far fa-envelope"></i></div>
                                <div class="content-email">
                                    <div class="text">
                                        <?php esc_html_e('Email Us','wpbookinghotel');?>
                                    </div>
                                    <div class="content">
                                        <?php echo (isset($hotel->email)?$hotel->email:'');?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="rating-review">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="title-rating">
                                        <h4><?php esc_html_e('Ratings','wpbookinghotel');?></h4>
                                    </div>
                                    <div class="quality-star">
                                        <div class="number-star">
                                            <span><?php echo (!empty($list_review)?number_format((float)$hotel_rating,2):0);?></span>
                                        </div>
                                        <span class="text-star">
                                            <span><?php esc_html_e('Overall Rating of','wpbookinghotel');?></span>
                                            <span><?php echo (esc_html(count($list_review)));?></span>
                                            <span><?php esc_html_e('guest rating', 'wpbookinghotel');?></span>
                                        </span>
                                    </div>
                                    <div class="overall-rating">
                                        <div class="block-item-rating">
                                            <ul class="list-rating-star">
                                                <?php for($i = 1; $i <= 5; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                            </ul>
                                            <div class="progress">
                                                <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($five_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($five_star)/count($list_review):0);?>)">
                                                </div>
                                            </div>
                                            <div class="number-rating"><?php echo (esc_html(count($five_star)));?></div>
                                        </div>
                                        <div class="block-item-rating">
                                            <ul class="list-rating-star">
                                                <?php for($i = 1; $i <= 4; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                                <li class="item-star"><i class="far fa-star"></i></li>
                                            </ul>
                                            <div class="progress">
                                                <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($four_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($four_star)/count($list_review):0);?>)">
                                                </div>
                                            </div>
                                            <div class="number-rating"><?php echo (esc_html(count($four_star)));?></div>
                                        </div>
                                        <div class="block-item-rating">
                                            <ul class="list-rating-star">
                                                <?php for($i = 1; $i <= 3; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                                <?php for($i = 1; $i <= 2; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            </ul>
                                            <div class="progress">
                                                <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($three_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($three_star)/count($list_review):0);?>)">
                                                </div>
                                            </div>
                                            <div class="number-rating"><?php echo (esc_html(count($three_star)));?></div>
                                        </div>
                                        <div class="block-item-rating">
                                            <ul class="list-rating-star">
                                                <?php for($i = 1; $i <= 2; $i++) {?>
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php }?>
                                                <?php for($i = 1; $i <= 3; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            </ul>
                                            <div class="progress">
                                                <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($two_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($two_star)/count($list_review):0);?>)">
                                                </div>
                                            </div>
                                            <div class="number-rating"><?php echo (esc_html(count($two_star)));?></div>
                                        </div>
                                        <div class="block-item-rating">
                                            <ul class="list-rating-star">
                                                <li class="item-star"><i class="fas fa-star"></i></li>
                                                <?php for($i = 1; $i <= 4; $i++) {?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                <?php }?>
                                            </ul>
                                            <div class="progress">
                                                <div class="progress-bar progress-bar-striped" role="progressbar" aria-valuenow="<?php echo (!empty($list_review)?(count($one_star)/count($list_review)) * 100:0);?>" aria-valuemin="0" aria-valuemax="100" style="width:calc( 100% * <?php esc_attr_e(!empty($list_review)?count($one_star)/count($list_review):0);?>)">
                                                </div>
                                            </div>
                                            <div class="number-rating"><?php echo (esc_html(count($one_star)));?></div>
                                        </div>
                                    </div>

                                </div>
                                <div class="col-md-6">
                                    <form action="" method="post" name="form-review">
                                        <div class="title-review">
                                            <h4><?php esc_html_e('Your Reviews','wpbookinghotel');?></h4>
                                            <div class="block-rating-star">
                                                <?php
                                                    $field = $this->form_review->getField('rating');
                                                    echo ($field->input);
                                                ?>
                                            </div>
                                        </div>
                                        <div class="input-review">
                                            <div class="row row-form-review">
                                                    <div class="col-md-6">
                                                        <div class="block-name">
                                                            <?php
                                                                $field = $this->form_review->getField('name');
                                                                echo ($field->input);
                                                            ?>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="block-email">
                                                            <?php
                                                                $field = $this->form_review->getField('email');
                                                                echo ($field->input);
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <div class="row row-form-review">
                                                <div class="col-md-12">
                                                    <div class="block-title">
                                                        <?php
                                                        $field = $this->form_review->getField('title');
                                                        echo($field->input);
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row row-form-review">
                                                <div class="col-md-12">
                                                    <div class="block-comment">
                                                        <?php
                                                        $field = $this->form_review->getField('comments');
                                                        echo ($field->input);
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="btn-submit">
                                                    <button type="button" class="btn btn-primary btn-save-review"><?php esc_html_e('Submit','wpbookinghotel');?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <?php echo ($this->form_review->renderField('id')) ?>
                                        <input type="hidden" name="task" value="review.save_review">
                                        <input type="hidden" name="link_redirect" value="<?php echo (esc_attr($this->page_hotel_detail));?>">
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="comment">
                            <div class="wrapper-list-review"></div>
                            <ul class="pagination-review"></ul>
                        </div>

                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="content-right">
                    <div class="title">
                        <h4><?php esc_html_e('Check Availability','wpbookinghotel');?></h4>
                    </div>
                    <div class="input-right">
                        <form action="<?php echo($this->page_checkout_default.'?hotel_id='.$hotel->id);?>" method="post" name="booking-form">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="block-check-in">
                                        <?php
                                            $field = $this->form->getField('check_in');
                                            echo ($field->input);
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="block-check-out">
                                        <?php
                                            $field = $this->form->getField('check_out');
                                            echo ($field->input);
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="block-number-adult">
                                        <?php
                                            $field = $this->form->getField('number_adult');
                                            echo ($field->input);
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="block-number-child">
                                        <?php
                                            $field = $this->form->getField('number_child');
                                            echo ($field->input);
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="block-select-roomtype">
                                        <?php
                                            $field = $this->form->getField('roomtype_id');
                                            echo ($field->input);
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="btn-book-now">
                                        <button type="button" class="btn btn-primary btn-booking-hotel"><?php esc_html_e('Book now','wpbookinghotel');?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-hotel-detail', 'view_hotel_detail', array(
        "render_list_review"=>$render_list_review($list_review)
), 'frontend/app/assets/js/view_hotel_detail.js');