<?php


use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotelFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;
use WpBookingHotelFrontend\app\Html\HtmlFrontend;

$doc = FactoryAlias::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('confirm');
WpBookingHotelHtmlFrontend::load_jquery_library('loading_js');
WpBookingHotelHtmlFrontend::load_jquery_library('validate');
$doc->addLessStyleSheet('frontend/app/assets/less/view_checkout_default.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');

$data_booking = $this->data;
$date_checkin = isset($data_booking['check_in'])?$data_booking['check_in']:'';
$date_checkout = isset($data_booking['check_out'])?$data_booking['check_out']:'';
$nights = (strtotime($date_checkout)-strtotime($date_checkin)) / 86400;
$number_adult = isset($data_booking['number_adult'])?$data_booking['number_adult']:0;
$number_child = isset($data_booking['number_child'])?$data_booking['number_child']:0;
$roomtype_id = isset($data_booking['roomtype_id'])?$data_booking['roomtype_id']:0;
$hotel = $this->hotel;
$list_roomtype = isset($hotel->list_roomtype)?$hotel->list_roomtype:array();
$roomtype_select = array();
if(!empty($list_roomtype)) {
    foreach ($list_roomtype as $roomtype) {
        if($roomtype->id == $data_booking['roomtype_id']) {
            array_push($roomtype_select, $roomtype);
        }
    }
}
$price_roomtype = 0;

$input = FactoryAlias::getInput();
$hotel_id =  $input->getInt(    'hotel_id',0);
$order_id =  $input->getInt('order_id',0);

$page_checkout_default= ConfigHelperAlias::get_page_checkout();
if($page_checkout_default) {
    $this->page_checkout_default = get_page_link($page_checkout_default);
}else{
    $this->page_checkout_default="";
}
$wordpress = FactoryAlias::getWordpress(0);
$uri=FactoryAlias::getUri();

$config=FactoryAlias::getConfig();
$live_site=$config->get('live_site');

?>
<div class="view-checkout-default">
    <ul class="nav nav-tabs menu-tab-block">
        <li class="active menu-item"><a href="javascript:void(0)"><?php esc_html_e('Customer Information','wpbookinghotel');?></a></li>
        <li class="menu-item"><a  href="javascript:void(0)"><?php esc_html_e('Summary','wpbookinghotel');?></a></li>
        <li class="menu-item"><a href="javascript:void(0)"><?php esc_html_e('Payment','wpbookinghotel');?></a></li>
    </ul>
    <?php if($hotel_id > 0) {?>
        <form action="<?php echo $live_site . $wordpress->get_wpbookinghotel_api_task() ?>" method="post" name="form-booking">
            <div class="tab-content">
                <div id="customer-info" class="tab-pane fade in active">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="block-customer-info">
                                <div class="title">
                                    <h4><?php esc_html_e('Customer Info','wpbookinghotel');?></h4>
                                </div>
                                <div class="block-input">
                                    <div class="block-input-item first-name">
                                        <?php
                                            echo ($this->form->renderField('first_name'))
                                        ?>
                                        <p class="notice-error-1" ><?php esc_html_e('This field is required','wpbookinghotel')?></p>
                                        <p class="notice-error-2"><?php esc_html_e('This field must not contain number ','wpbookinghotel')?></p>
                                    </div>
                                    <div class="block-input-item last-name">
                                        <?php
                                            echo ($this->form->renderField('last_name'))
                                        ?>
                                        <p class="notice-error-1"><?php esc_html_e('This field is required','wpbookinghotel')?></p>
                                        <p class="notice-error-2"><?php esc_html_e('This field must not contain number','wpbookinghotel')?></p>
                                    </div>
                                    <div class="block-input-item email">
                                        <?php
                                            echo ($this->form->renderField('email'))
                                        ?>
                                        <p class="notice-error-1"><?php esc_html_e('This field is required','wpbookinghotel')?></p>
                                        <p class="notice-error-2"><?php esc_html_e('Please enter a valid email : example@email.com','wpbookinghotel')?></p>
                                    </div>
                                    <div class="block-input-item address">
                                        <?php
                                            echo ($this->form->renderField('address'))
                                        ?>
                                        <p class="notice-error-1"><?php esc_html_e('This field is required','wpbookinghotel')?></p>
                                    </div>
                                    <div class="block-input-item post-code">
                                        <?php
                                            echo ($this->form->renderField('post_code'))
                                        ?>
                                        <p class="notice-error-1"><?php esc_html_e('This field is required','wpbookinghotel')?></p>
                                    </div>
                                    <div class="block-input-item city">
                                        <?php
                                            echo ($this->form->renderField('city'))
                                        ?>
                                        <p class="notice-error-1"><?php esc_html_e('This field is required','wpbookinghotel')?></p>
                                    </div>
                                    <div class="block-input-item country">
                                        <?php
                                            echo ($this->form->renderField('country_id'))
                                        ?>
                                        <p class="notice-error"><?php esc_html_e('This field is required','wpbookinghotel')?></p>
                                    </div>
                                    <div class="block-input-item phone">
                                        <?php
                                            echo ($this->form->renderField('phone'))
                                        ?>
                                        <p class="notice-error-1"><?php esc_html_e('This field is required','wpbookinghotel')?></p>
                                        <p class="notice-error-2"><?php esc_html_e('This field must not contain character','wpbookinghotel')?></p>
                                    </div>
                                    <div class="block-input-item city">
                                        <?php
                                            echo ($this->form->renderField('company'));
                                        ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="block-info-booking">
                                <div class="block-booking-detail">
                                    <div class="title">
                                        <h4><?php esc_html_e('Booking details','wpbookinghotel');?></h4>
                                    </div>
                                    <div class="booking-detail-info">
                                        <p>
                                            <span><?php esc_html_e('Check in','wpbookinghotel');?></span>
                                            <span><?php echo (esc_html($date_checkin));?></span>
                                        </p>
                                        <p>
                                            <span><?php esc_html_e('Check out','wpbookinghotel');?></span>
                                            <span><?php echo (esc_html($date_checkout));?></span>
                                        </p>
                                        <div class="content">
                                            <p>
                                                <span><?php echo (esc_html($nights));?></span>
                                                <span><?php esc_html_e('night(s)','wpbookinghotel');?></span>
                                            </p>
                                            <p>
                                                <span><?php echo ($number_adult + $number_child);?></span>
                                                <span><?php esc_html_e('person(s)','wpbookinghotel');?></span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php if(!empty($roomtype_select)) {?>
                                    <?php foreach ($roomtype_select as $roomtype_select_item) {?>
                                        <?php $price_roomtype += $roomtype_select_item->price_adult*$number_adult + $roomtype_select_item->price_child*$number_child; ?>
                                        <div class="block-room-type">
                                    <div class="title">
                                        <h4><?php esc_html_e('Room type','wpbookinghotel');?></h4>
                                    </div>

                                    <div class="block-item">
                                        <div class="detail-roomtype">
                                            <span><?php echo (isset($roomtype_select_item->name)?$roomtype_select_item->name:'');?></span>
                                            <div class="left">
                                                <span><?php echo (esc_html($nights));?> <?php esc_html_e('nights');?></span>
                                                <span><?php echo (FrontendHelper::format_currency(number_format((float)($roomtype_select_item->price_adult*$number_adult + $roomtype_select_item->price_child*$number_child),2)));?></span>
                                            </div>

                                        </div>
                                        <div class="number-person">
                                            <div class="total-person">
                                                <span><?php echo (esc_html($number_adult + $number_child));?></span>
                                                <span><?php esc_html_e('person(s)','wpbookinghotel');?></span>
                                            </div>
                                            <div class="total-adult">
                                                <span><?php esc_html_e('Adults','wpbookinghotel');?></span>
                                                <div class="total-adult-item">
                                                    <span><?php esc_html_e($number_adult);?></span>
                                                    <span><?php echo (FrontendHelper::format_currency(number_format((float)($roomtype_select_item->price_adult),2)));?></span>
                                                </div>
                                            </div>
                                            <div class="total-child">
                                                <span><?php esc_html_e('Children','wpbookinghotel');?></span>
                                                <div class="total-child-item">
                                                    <span><?php echo (esc_html($number_child));?></span>
                                                    <span><?php echo (FrontendHelper::format_currency(number_format((float)($roomtype_select_item->price_child),2)));?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                    <?php }?>
                                <?php }?>
                                <?php if(isset($this->hotel->list_service) && !empty($this->hotel->list_service)) {?>
                                    <div class="block-extra-service">
                                        <div class="title">
                                            <h4><?php esc_html_e('Extra services','wpbookinghotel');?></h4>
                                        </div>
                                        <div class="block-item-service">
                                            <?php foreach ($this->hotel->list_service as $service) {?>
                                                    <div class="item">
                                                        <div class="left">
                                                            <input type="checkbox" name="service_id[]" id="service-item-<?php echo (esc_attr($service->id));?>" value="<?php echo (esc_attr($service->id));?>">
                                                            <label for="service-item-<?php echo (esc_attr($service->id));?>"><?php echo (isset($service->name)?$service->name:'');?></label>
                                                        </div>
                                                        <div class="right">
                                                            <span><?php echo (esc_html($nights));?> <?php esc_html_e('nights');?></span>
                                                            <span><?php echo (FrontendHelper::format_currency(number_format(isset($service->price_service)?$service->price_service:0, 2)));?></span>
                                                        </div>
                                                    </div>
                                                <?php }?>
                                        </div>
                                    </div>
                                <?php }?>
                                <div class="block-total">
                                    <span><?php esc_html_e('Total','wpbookinghotel');?></span>
                                    <span class="total-1"><?php echo (FrontendHelper::format_currency(number_format((float)$price_roomtype * $nights,2)));?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="wrapper-button">

                            <button type="button" class="btn-previous"><?php esc_html_e('Previous step','wpbookinghotel');?></button>
                            <button type="button" class="btn-next"><?php esc_html_e('Next step','wpbookinghotel');?></button>
                        </div>
                    </div>
                </div>
                <div id="summary" class="tab-pane fade">
                    <div class="row">
                        <div class="col-md-12">
                            <table class="table-1">
                                <thead>
                                <tr>
                                    <th><?php esc_html_e('Booking details','wpbookinghotel');?></th>
                                    <th><?php esc_html_e('Billing address','wpbookinghotel');?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td>
                                        <span class="check-in"><?php esc_html_e('Check in','wpbookinghotel');?></span>
                                        <span><?php echo (esc_html($date_checkin));?></span>
                                    </td>
                                    <td>
                                        <span class="info-booking"><?php esc_html_e('Full name','wpbookinghotel');?></span>
                                        <span class="detail-booking customer-name">Jonh Doe</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="check-out"><?php esc_html_e('Check out','wpbookinghotel');?></span>
                                        <span><?php echo (esc_html($date_checkout));?></span>
                                    </td>
                                    <td>
                                        <span class="info-booking"><?php esc_html_e('Address','wpbookinghotel');?></span>
                                        <span class="detail-booking customer-address">Jonh Doe</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span><?php echo (esc_html($nights));?></span>
                                        <span><?php esc_html_e('night','wpbookinghotel');?></span>
                                    </td>
                                    <td>
                                        <span class="info-booking"><?php esc_html_e('Post code','wpbookinghotel');?></span>
                                        <span class="detail-booking customer-postcode">SE1</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <div class="number-person-1">
                                            <div class="left">
                                                <span><?php echo ($number_child + $number_adult);?></span>
                                                <span><?php esc_html_e('person','wpbookinghotel');?></span>
                                            </div>
                                            <div class="right">
                                                <p>
                                                    <span><?php esc_html_e('Adult','wpbookinghotel');?></span>
                                                    <span><?php echo (esc_html($number_adult));?></span>
                                                </p>
                                                <p>
                                                    <span><?php esc_html_e('Child','wpbookinghotel');?></span>
                                                    <span><?php echo (esc_html($number_child));?></span>
                                                </p>
                                            </div>
                                        </div>

                                    </td>
                                    <td>
                                        <span class="info-booking"><?php esc_html_e('City','wpbookinghotel');?></span>
                                        <span class="detail-booking customer-city">London</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="hollow"></td>
                                    <td>
                                        <span class="info-booking"><?php esc_html_e('Phone','wpbookinghotel');?></span>
                                        <span class="detail-booking customer-phone">123456</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="hollow"></td>
                                    <td>
                                        <span class="info-booking"><?php esc_html_e('Email','wpbookinghotel');?></span>
                                        <span class="detail-booking customer-email">support@pandao.eu</span>
                                    </td>
                                </tr>

                                </tbody>
                            </table>
                            <?php if(!empty($roomtype_select)) {?>
                                <table class="table-2">
                                <thead>
                                    <tr>
                                        <th><?php esc_html_e('Room type','wpbookinghotel');?></th>
                                        <th><?php esc_html_e('Person','wpbookinghotel');?></th>
                                        <th><?php esc_html_e('Total','wpbookinghotel');?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($roomtype_select as $roomtype_select_item) {?>
                                        <tr>
                                    <td> <?php echo (isset($roomtype_select_item->name)?$roomtype_select_item->name:'');?> </td>
                                    <td>
                                        <div class="number-person-2">
                                            <div class="left">
                                                <span><?php echo ($number_child + $number_adult); ?></span>
                                                <span><?php esc_html_e('person','wpbookinghotel');?></span>
                                            </div>
                                            <div class="right">
                                                <?php if($number_adult > 0) {?>
                                                    <p>
                                                        <span><?php esc_html_e('Adult','wpbookinghotel');?></span>
                                                        <span><?php echo (esc_html($number_adult));?></span>
                                                    </p>
                                                <?php }?>
                                                <?php if($number_child > 0) {?>
                                                    <p>
                                                        <span><?php esc_html_e('Child','wpbookinghotel');?></span>
                                                        <span><?php echo (esc_html($number_child));?></span>
                                                    </p>
                                                <?php }?>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?php echo (FrontendHelper::format_currency(number_format((float)$price_roomtype * $nights,2)));?></td>
                                </tr>
                                    <?php }?>
                                </tbody>
                            </table>
                            <?php }?>
                            <?php if(isset($hotel->list_service) && !empty($hotel->list_service)) {?>
                                <table class="table-3">
                                    <thead>
                                        <tr>
                                            <th><?php esc_html_e('Service','wpbookinghotel');?></th>
                                            <th><?php esc_html_e('Quantity','wpbookinghotel');?></th>
                                            <th><?php esc_html_e('Total','wpbookinghotel');?></th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            <?php }?>
                            <table class="table-4">
                                <tbody>
                                <tr>
                                    <td><?php esc_html_e('Total','wpbookinghotel');?></td>
                                    <td class="total-2">$211.25</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="wrapper-button">
                                <button type="button" class="btn-previous"><?php esc_html_e('Previous step','wpbookinghotel');?></button>
                                <button type="button" class="btn-confirm-booking"><?php esc_html_e('Confirm booking','wpbookinghotel');?></button>
                            </div>
                        </div>
                    </div>

                </div>
                <div id="payment" class="tab-pane fade">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="block-select-method">
                                <?php
                                $field = $this->form->getField('payment_id');
                                $disable_payment_online = isset($this->item->disable_payment_online) ? (boolean)$this->item->disable_payment_online : false;

                                $field->setDisablePaymentOnline($disable_payment_online);
                                echo($field->input);
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="wrapper-button">
                                <?php if($hotel_id > 0) {?>
                                    <button type="button" class="btn-previous"><?php esc_html_e('Previous step','wpbookinghotel');?></button>
                                <?php }?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <input type="hidden" name="task" value="booking.book_hotel">
            <input type="hidden" name="link_redirect" value="<?php echo (esc_attr($this->page_checkout_default));?>">
            <input type="hidden" name="check_in" value="<?php echo (esc_attr($date_checkin));?>">
            <input type="hidden" name="check_out" value="<?php echo (esc_attr($date_checkout));?>">
            <input type="hidden" name="number_adult" value="<?php echo (esc_attr($number_adult));?>">
            <input type="hidden" name="number_child" value="<?php echo (esc_attr($number_child));?>">
            <input type="hidden" name="roomtype_id" value="<?php echo (esc_attr($roomtype_id));?>">
            <input type="hidden" name="nights" value="<?php echo (esc_attr($nights));?>">
            <input type="hidden" name="hotel_id" value="<?php echo (esc_attr($hotel_id));?>">
        </form>
    <?php } elseif ($order_id > 0) {?>
        <div class="tab-content">
            <div id="payment" class="tab-pane fade in active">
                <div class="block-checkout">
                    <?php if($uri->getVar('page') == '') {?>
                        <?php echo($this->paymentPlugin->onAfterOrderConfirm($this->order)) ?>
                    <?php } elseif ($uri->getVar('page') == 'cancel') {?>
                        <div class="content-cancel">
                            <p><?php esc_html_e('The payment has been cancelled.','wpbookinghotel');?></p>
                            <p><?php esc_html_e('Thank you for your visit and see you soon.','wpbookinghotel');?></p>
                        </div>
                        <?php echo($this->paymentPlugin->onAfterOrderConfirm($this->order)) ?>
                    <?php } elseif ($uri->getVar('page') == 'thanks') {?>
                        <div class="content-thanks">
                            <p><?php esc_html_e('The payment has been successed.','wpbookinghotel');?></p>
                            <p><?php esc_html_e('Thank you for your visit and see you soon.','wpbookinghotel');?></p>
                        </div>

                    <?php }?>
                </div>
            </div>
        </div>
    <?php }?>
</div>
<?php
$doc->addScriptApplySelector('.view-checkout-default','view_checkout_default',array(
    "hotel"=>$hotel,
    "price_roomtype"=>$price_roomtype,
    "nights"=>$nights
),"frontend/app/assets/js/view_checkout_default.js");
?>
