<?php
namespace WpBookingHotelFrontend\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory as FactoryAlias;

use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Utilities\Utility as UtilityAlias;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;
class ServicesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "services";
    /**
     * @var string
     */
    public $table_name = "service";
    public function getListQuery()
    {
        $input=FactoryAlias::getInput();
        $data=$input->getData();
        $location_id=$input->getInt('location',0);
        $price_search=$input->getString('price_search',"");


        if($price_search!==""){
            $price_search=(array)json_decode($price_search);
        }
        $category=[];
        if(array_key_exists('category',(array)$data)) {
            $category=$data['category'];
            if(!empty($category)){
                $category=(array)$category;
            }
        }
        $employee=[];
        if(array_key_exists('employee',(array)$data)) {
            $employee=$data['employee'];
            if(!empty($employee)){
                $employee=(array)$employee;
            }
        }

        $query=$this->db->getQuery(true);
        $query->select("DISTINCT a.*")
            ->from($this->getTableName("service").' AS a')
            ->where('a.published=1')
        ;
        $query->order($this->getState('list.ordering', 'a.ordering') . ' ' . $this->getState('list.direction', 'ASC'));
        if($location_id!=0){
            $query
                ->where('a.location_id='.(int)$location_id)
            ;
        }

        if(is_array($price_search) && !empty($price_search)){
            $min=reset($price_search);
            $max=end($price_search);

            $query->where('a.price>='.(float)$min);
            $query->where('a.price<='.(float)$max);
        }
        if(is_array($employee) && !empty($employee)){

            $query
                ->leftJoin($this->getTableName("service_employee").' AS service_employee ON service_employee.service_id=a.id')
                ->where('service_employee.employee_id IN ('.implode($employee,",").')')
            ;
        }
        if(is_array($category) && !empty($category)){

            $query
                ->where('a.category_id IN ('.implode($category,",").')')
            ;
        }
        $query->group('a.id');
        return $query;
    }
    public function getList()
    {
        $db=FactoryAlias::getDBO();
        $query=$this->getListQuery();
        $list_service=$db->setQuery($query)->loadObjectList();
        foreach ($list_service as &$item) {
            $query = $this->db->getQuery(true);
            $query->clear()
                ->select('category.*')
                ->from($this->getTableName('category') . ' AS category')
                ->where('category.id=' . (int)$item->category_id);
            $item->category = $this->db->setQuery($query)->loadObject();


            $query->clear()
                ->select('employee.*')
                ->from($this->getTableName('employee') . ' AS employee')
                ->leftJoin($this->getTableName('service_employee') . ' AS service_employee ON service_employee.employee_id=employee.id')
                ->where('service_employee.service_id=' . (int)$item->id);
            $list_employee = $this->db->setQuery($query)->loadObjectList();


            $list_employee_id = [];
            foreach ($list_employee as $employee) {
                $employee->full_name = $employee->first_name. ' ' .$employee->last_name;
                array_push($list_employee_id, $employee->id);
            }
            $item->list_employee = $list_employee;
            $item->list_employee_id = $list_employee_id;
            $query->clear()
                ->select('location.*')
                ->from($this->getTableName('location') . ' AS location')
                ->where('location.id=' . (int)$item->location_id)
            ;
            $location = $this->db->setQuery($query)->loadObjectList();
            $item->location = reset($location);

            $register = new Registry();
            $register->loadString($item->params);
            $item->params = $register;
        }
        return $list_service;
    }

}
