<?php
namespace WpBookingHotelFrontend\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use Exception;
use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Filesystem\File as FileAlias;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;

class RoomtypeModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "roomtype";
    /**
     * @var string
     */
    public $table_name = "roomtype";

    public function getItem($id = 0)
    {
        $roomtype =  parent::getItem($id); // TODO: Change the autogenerated stub
        $query = $this->_db->getQuery(true);
        $query->clear()
            ->select('price_adult')
            ->from($this->getTableName('hotelproperty'))
            ->where('object_id='.(int)$roomtype->id)
            ->where('type='.$query->quote(FrontendHelper::getWpBookingRoomtypeKey()))
            ;
        $roomtype->price_adult = $this->_db->setQuery($query)->loadResult();
        $query->clear()
            ->select('price_child')
            ->from($this->getTableName('hotelproperty'))
            ->where('object_id='.(int)$roomtype->id)
            ->where('type='.$query->quote(FrontendHelper::getWpBookingRoomtypeKey()))
            ;
        $roomtype->price_child = $this->_db->setQuery($query)->loadResult();

        $query->clear()
        ->select('amenity.*')
            ->from($this->getTableName('amenity'). ' AS amenity')
            ->leftJoin($this->getTableName('roomtype_amenity'). ' AS roomtype_amenity ON roomtype_amenity.amenity_id=amenity.id')
            ->where('roomtype_amenity.roomtype_id =' .(int)$roomtype->id)
        ;
        $list_amenity=$this->_db->setQuery($query)->loadObjectList();
        $roomtype->list_amenity = $list_amenity;

        return $roomtype;
    }
}
