<?php
namespace WpBookingHotelFrontend\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use Exception;
use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Filesystem\File as FileAlias;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotelFrontend\app\helpers\ConfigHelper;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;

class ReviewModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "review";
    /**
     * @var string
     */
    public $table_name = "review";


    public function save_review($data = array())
    {
        $created_date = Factory::getDate();
        $data['created_date'] = $created_date->toSql();
        $data['published'] = 1;
        $review = $this->save($data);
        $hotel_id = isset($data['hotel_id'])?$data['hotel_id']:0;
        $query = $this->_db->getQuery(true);
        $query->clear()
            ->insert($this->getTableName('hotelproperty'))
            ->set('object_id='.(int)($review->id))
            ->set('hotel_id='.(int)$hotel_id)
            ->set('type='.$query->quote(FrontendHelper::getWpBookingReviewKey()))
            ;
        $this->_db->setQuery($query)->execute();
    }

}
