<?php
namespace WpBookingHotelFrontend\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;
use WpBookingHotelFrontend\app\Html\HtmlFrontend;

class OrderModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "order";
    /**
     * @var string
     */
    public $table_name = "order";
    public function getItem($id = 0)
    {
        $item = (object)parent::getItem($id); // TODO: Change the autogenerated stub
        $query = $this->db->getQuery(true);
        $query->clear()
            ->select('customer.*')
            ->from($this->getTableName('customer') . ' AS customer')
            ->where('customer.id=' . (int)$item->customer_id);
        $item->customer = $this->db->setQuery($query)->loadObjectList();
        $item->customer_full_name = $item->customer[0]->first_name .' '.$item->customer[0]->last_name;
        $query->clear()
            ->select("order_detail.*")
            ->from($this->getTableName('order_detail') . ' AS order_detail')
            ->where('order_detail.order_id=' . (int)$id);
        $item->list_order_detail = $this->db->setQuery($query)->loadObjectList();
        $list_rate=[];
        foreach ($item->list_order_detail as $order_detail) {
            $query->clear()
                ->select("order_detail_rate.*")
                ->from($this->getTableName('order_detail_rate') . ' AS order_detail_rate')
                ->leftJoin($this->getTableName('hotel') . ' AS hotel ON hotel.id=order_detail_rate.hotel_id')
                ->where('order_detail_id=' . (int)$order_detail->id);
            $list_rate = $this->db->setQuery($query)->loadObjectList();
        }
        $item->list_rate = $list_rate;
        return $item;
    }
}
