<?php
namespace WpBookingHotelFrontend\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use Exception;
use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Filesystem\File as FileAlias;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotelFrontend\app\helpers\FrontendHelper;

class HotelModel extends ModelForm
{
    /**
     * @var string
     */
    public $context = "hotel";
    /**
     * @var string
     */
    public $table_name = "hotel";

    public function getItem($id = 0)
    {
        $hotel = (object)parent::getItem($id); // TODO: Change the autogenerated stub
        $query = $this->_db->getQuery(true);
        $query->clear()
            ->select('location.*')
            ->from($this->getTableName('location').' AS location')
            ->leftJoin($this->getTableName('hotelproperty').' AS hotelproperty ON hotelproperty.object_id=location.id')
            ->where('hotelproperty.hotel_id='.(int)$id)
            ->where('hotelproperty.type='.$query->quote(FrontendHelper::getWpBookingDestinationKey()))
            ;
        $destination = $this->_db->setQuery($query)->loadObject();
        $hotel->destination = $destination;

        $query->clear()
            ->select('review.*')
            ->from($this->getTableName('review').' AS review')
            ->leftJoin($this->getTableName('hotelproperty').' AS hotelproperty ON hotelproperty.object_id=review.id')
            ->where('hotelproperty.hotel_id='.(int)$id)
            ->where('hotelproperty.type='.$query->quote(FrontendHelper::getWpBookingReviewKey()))
            ->where('review.published=1')
            ;
        $list_review = $this->_db->setQuery($query)->loadObjectList();
        $rating_sum = 0;
        if(!empty($list_review)) {
            foreach ($list_review as $review){
                if(isset($review->rating) && $review->rating) {
                    $rating_sum += $review->rating;
                }
            }
        }

        $hotel->rating_avg = !empty($list_review)?($rating_sum / count($list_review)):0;
        $hotel->list_review = $list_review;

        $query->clear()
            ->select('tag.name')
            ->from($this->getTableName('tag').' AS tag')
            ->leftJoin($this->getTableName('hotelproperty').' AS hotelproperty ON hotelproperty.object_id=tag.id')
            ->where('hotelproperty.hotel_id='.(int)$id)
            ->where('hotelproperty.type='.$query->quote(FrontendHelper::getWpBookingTagKey()))
            ;
        $list_tag = $this->_db->setQuery($query)->loadColumn();
        $hotel->tag_name = $list_tag;

        $query->clear()
            ->select('service.*')
            ->from($this->getTableName('service').' AS service')
            ->leftJoin($this->getTableName('hotelproperty').' AS hotelproperty ON hotelproperty.object_id=service.id')
            ->where('hotelproperty.hotel_id='.(int)$id)
            ->where('hotelproperty.type='.$query->quote(FrontendHelper::getWpBookingServiceKey()))
            ;
        $list_service = $this->_db->setQuery($query)->loadObjectList();

        $query->clear()
            ->select('wishlist.user_id')
            ->from($this->getTableName('wishlist').' AS wishlist')
            ->where('wishlist.hotel_id='.(int)$id);
        $hotel->user_wishlist = $this->_db->setQuery($query)->loadColumn();

        foreach ($list_service as &$service) {
            $query->clear()
                ->select('hotelproperty.price_service')
                ->from($this->getTableName('hotelproperty'). ' AS hotelproperty')
                ->where('hotelproperty.object_id='.(int)$service->id)
                ->where('hotelproperty.type='.$query->quote(FrontendHelper::getWpBookingServiceKey()))
                ->where('hotelproperty.hotel_id='.(int)$id)
            ;
            $service->price_service = $this->_db->setQuery($query)->loadResult();
        }
        $hotel->list_service = $list_service;

        $query->clear()
            ->select('roomtype.*')
            ->from($this->getTableName('roomtype').' AS roomtype')
            ->leftJoin($this->getTableName('hotelproperty').' AS hotelproperty ON hotelproperty.object_id=roomtype.id')
            ->where('hotelproperty.hotel_id='.(int)$id)
            ->where('hotelproperty.type='.$query->quote(FrontendHelper::getWpBookingRoomtypeKey()))
        ;
        $list_roomtype = $this->_db->setQuery($query)->loadObjectList();
        foreach ($list_roomtype as &$roomtype) {
            $query->clear()
                ->select('hotelproperty.price_adult')
                ->from($this->getTableName('hotelproperty'). ' AS hotelproperty')
                ->where('hotelproperty.object_id='.(int)$roomtype->id)
                ->where('hotelproperty.type='.$query->quote(FrontendHelper::getWpBookingRoomtypeKey()))
                ->where('hotelproperty.hotel_id='.(int)$id)
                ;
            $roomtype->price_adult = $this->_db->setQuery($query)->loadResult();
            $query->clear()
                ->select('hotelproperty.price_child')
                ->from($this->getTableName('hotelproperty'). ' AS hotelproperty')
                ->where('hotelproperty.object_id='.(int)$roomtype->id)
                ->where('hotelproperty.type='.$query->quote(FrontendHelper::getWpBookingRoomtypeKey()))
                ->where('hotelproperty.hotel_id='.(int)$id)
                ;
            $roomtype->price_child = $this->_db->setQuery($query)->loadResult();

            $query->clear()
                ->select('amenity.*')
                ->from($this->getTableName('amenity'). ' AS amenity')
                ->leftJoin($this->getTableName('roomtype_amenity'). ' AS roomtype_amenity ON roomtype_amenity.amenity_id=amenity.id')
                ->where('roomtype_amenity.roomtype_id='.(int)$roomtype->id)
            ;
            $roomtype->list_amenity = $this->_db->setQuery($query)->loadObjectList();

        }
        $hotel->list_roomtype = $list_roomtype;

        $query->clear()
            ->select('gallery.*')
            ->from($this->getTableName('gallery').' AS gallery')
            ->where('gallery.object_id='.(int)$id)
            ->where('gallery.type='.$query->quote('hotel'))
        ;
        $gallery = $this->_db->setQuery($query)->loadObjectList();
        $hotel->gallery = $gallery;

        $params = isset($hotel->params)?$hotel->params:'';
        $register = new Registry();
        $register->loadString($params);
        $hotel->params = $register;
        return $hotel;
    }


}
