<?php
namespace WpBookingHotelFrontend\app\models;
defined('_WPBOOKINGHOTEL_EXEC') or die;

use WpBookingHotel\Factory;
use WpBookingHotel\Factory as FactoryAlias;
use WpBookingHotel\Mvc\Model\ModelForm;
use WpBookingHotel\Form\Form;
use WpBookingHotel\Mvc\Model\ModelList;
use WpBookingHotel\Registry\Registry;
use WpBookingHotel\Utilities\Utility as UtilityAlias;

class CountriesModel extends ModelList
{
    /**
     * @var string
     */
    public $context = "countries";
    /**
     * @var string
     */
    public $table_name = "country";
    public function getList()
    {
        $db=Factory::getDBO();
        $query=$this->getListQuery();

        return $db->setQuery($query)->loadObjectList();
    }
    public static function getList_location(){
        $db= FactoryAlias::getDBO();
        $query=$db->getQuery(true);
        $query->select('country.countryname')
            ->from(UtilityAlias::getTableName('country').' AS country ')
            ->leftJoin(UtilityAlias::getTableName('state').' AS state ON state.country_id=country.id')
            ->select('state.id AS state_id')
            ->where('country.id=state.country_id')
        ;

        $list_country=$db->setQuery($query)->loadObjectList();
        foreach ($list_country as &$country) {
            $query->clear()
                ->select('location.name AS location_name, location.id AS location_id')
                ->from(UtilityAlias::getTableName('location').' AS location')
                ->where('location.state_id='.(int)$country->state_id)
            ;
            $list_location = $db->setQuery($query)->loadObjectList();
            $country->list_location = $list_location;
        }
        return $list_country;
    }

    public function getListCountryLocationPopular() {
        $query = $this->_db->getQuery(true);
        $query->select('country.*')
            ->from($this->getTableName('country').' AS country')
            ->leftJoin($this->getTableName('state').' AS state ON state.country_id=country.id')
            ->leftJoin($this->getTableName('location').' AS location ON location.state_id=state.id')
            ->where('location.is_top_destination=1')
        ;
        $list_country = $this->_db->setQuery($query)->loadObjectList();
        return $list_country;
    }


}
