'use strict';
(function ($) {
    $.field_totalpeople = function (element, options) {
        var defaults = {
            name_field_number_adult:'',
            name_field_number_child:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element),
            element = element;

        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('.dropdown-menu').on('click', function (event) {
                event.stopPropagation();
            });
            $element.find('.btn-minius').on('click', function () {
                let $block_increment = $(this).closest('.block-increment');
                let value_current = $block_increment.find('input.input-field').val();
                $block_increment.find('.btn-plus').attr('disabled', false);
                if(value_current > 1) {
                    $block_increment.find('input.input-field').val(parseInt(value_current) - 1);
                    value_current = $block_increment.find('input.input-field').val();
                } else {
                    $(this).attr('disabled', true);
                }
                let $block_select = $(this).closest('.block-select');
                if($block_select.hasClass('block-select-adult')) {
                    $element.find(`input[name="${plugin.settings.name_field_number_adult['0']}"]`).val(parseInt(value_current));
                    $element.find('span.number-adult').text(parseInt(value_current));
                } else {
                    $element.find(`input[name="${plugin.settings.name_field_number_child['0']}"]`).val(parseInt(value_current));
                    $element.find('span.number-child').text(parseInt(value_current));
                }

            });
            $element.find('.btn-plus').on('click', function () {
                let $block_increment = $(this).closest('.block-increment');
                let value_current = $block_increment.find('input.input-field').val();
                $block_increment.find('.btn-minius').attr('disabled', false);
                if(value_current < 15) {
                    $block_increment.find('input.input-field').val(parseInt(value_current) + 1);
                    value_current = $block_increment.find('input.input-field').val();
                    $(this).attr('disabled', false);
                } else {
                    $(this).attr('disabled', true);
                }
                let $block_select = $(this).closest('.block-select');
                if($block_select.hasClass('block-select-adult')) {
                    $element.find(`input[name="${plugin.settings.name_field_number_adult['0']}"]`).val(parseInt(value_current));
                    $element.find('span.number-adult').text(parseInt(value_current));
                } else {
                    $element.find(`input[name="${plugin.settings.name_field_number_child['0']}"]`).val(parseInt(value_current));
                    $element.find('span.number-child').text(parseInt(value_current));
                }

            });
            $element.find('input.input-field').on('change',  function () {
                let value = $(this).val();
                if(value < 0) {
                    value = 0;
                    $(this).val(parseInt(value));
                } else if (value > 15) {
                    value = 15;
                    $(this).val(parseInt(value));
                }
                let $block_select = $(this).closest('.block-select');
                if($block_select.hasClass('block-select-adult')) {
                    $element.find(`input[name="${plugin.settings.name_field_number_adult['0']}"]`).val(parseInt(value));
                    $element.find('span.number-adult').text(parseInt(value));
                } else {
                    $element.find(`input[name="${plugin.settings.name_field_number_child['0']}"]`).val(parseInt(value));
                    $element.find('span.number-child').text(parseInt(value));
                }
            })

        };
        plugin.example_function = function () {
        };
        plugin.init();
    }

    $.fn.field_totalpeople = function (options) {

        return this.each(function () {

            if (undefined == $(this).data('field_totalpeople')) {
                var plugin = new $.field_totalpeople(this, options);
                $(this).data('field_totalpeople', plugin);
            }
        });
    }
})(jQuery);