<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
use WpBookingHotel\Language\Text;
use WpBookingHotelFrontend\app\Html\HtmlFrontend;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlFrontendAlias::load_jquery_library('moment');
WpBookingHotelHtmlFrontendAlias::load_jquery_library('daterangepicker');


$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/selectrates/selectrates.less');
$input = Factory::getInput();
$event_id = $input->getInt('event_id',0);
$modelRates = Model::getInstance('rates');
$list_rate= $modelRates->getListRateByEventId($event_id);
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name).'_'. $event_id;

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-selectrates">
        <ul class="wrapper-list-rate">
            <?php foreach ($list_rate as $rate) { ?>
                <li>
                    <div class="wrapper-rate" data-rate_id="<?php echo (esc_attr(isset($rate->id)?$rate->id:1)); ?>">
                        <div class="rate">
                            <span>
                                <?php echo(HtmlFrontend::render_date($rate->from,'H:i')); ?>-<?php echo(HtmlFrontend::render_date($rate->to,'H:i')); ?>
                            </span>
                        </div>
                    </div>
                </li>
            <?php } ?>
        </ul>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>" />
    </div>
<?php
$doc->addScriptApplySelector("#$id_by_name",'field_selectrates',array(
    "input_name"=>  $name,
),'frontend/app/layouts/WooBooking/form/field/selectrates/jquery.selectrates.js');
