<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_". $name;
$hotelModel = Model::getInstance('hotel');
$input = Factory::getInput();
$hotel_id = $input->getInt('hotel_id',0);
$hotel=$hotelModel->getItem($hotel_id);
$list_roomtype = $hotel->list_roomtype;
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-roomtype">
        <select name="<?php echo (esc_attr($name)); ?>" <?php $multiple ? ' multiple ' : null ?>
                class="form-control list-roomtype">
            <option value="">Select roomtype</option>
			<?php foreach ($list_roomtype as $roomtype) { ?>
                <option value="<?php echo (esc_attr($roomtype->id)); ?>"><?php esc_html_e($roomtype->name,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/roomtype/roomtype.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-roomtype','field_roomtype',array(
),'frontend/app/layouts/WooBooking/form/field/roomtype/roomtype.jquery.js');
