<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlFrontendAlias::load_jquery_library('moment');
WpBookingHotelHtmlFrontendAlias::load_jquery_library('daterangepicker');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"class="<?php echo (esc_attr($class)); ?> field-rating-star">
        <div class='rating-stars text-center'>
            <ul id='stars'>
                <li class='star' data-value='1'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='2'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='3'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='4'>
                    <i class="far fa-star"></i>
                </li>
                <li class='star' data-value='5'>
                    <i class="far fa-star"></i>
                </li>
            </ul>
        </div>
        <input type="hidden" name="<?php echo (esc_attr($name));?>">
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/ratingstar/ratingstar.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-rating-star','field_ratingstar',array(
        "input_name"=>$name
),'frontend/app/layouts/WooBooking/form/field/ratingstar/ratingstar.js');