<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlFrontendAlias::load_jquery_library('moment');
WpBookingHotelHtmlFrontendAlias::load_jquery_library('daterangepicker');


$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/rates/rates.less');
$id_by_name = "element_field_". $name;
$calendar_element_field_id="calendar_$id_by_name";
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-rates">
        <div class="wrapper-rates">
            <input type="text" class="calendar_rates" placeholder="<?php esc_attr_e('Calendar', 'wpbookinghotel')?>" />
            <i class="icon-nb-calendar"></i>
        </div>
        <input type="hidden" name="<?php echo (esc_attr($name)); ?>" value="<?php echo (esc_attr($value)) ?>">
    </div>
<?php
$doc->addScriptApplySelector("#$id_by_name",'field_rates',array(
    "input_name"=>  $name,
),'frontend/app/layouts/WooBooking/form/field/rates/jquery.rates.js');
