"use strict";
(function ($) {
    $.field_rates = function (element, options) {
        var defaults = {
            input_name: "",
            list_rate: ""
        };
        var plugin = this;
        plugin.settings = {}
        let $element = $(element);
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);

            let $input_element=$element.find('.calendar_rates');
            $input_element.daterangepicker({
                opens: 'left',
                timePicker: true,
                autoUpdateInput: false,
            }, function (start, end, label) {
                let rate = `${start.format('YYYY-MM-DD hh:mm:ss')};${end.format('YYYY-MM-DD hh:mm:ss')}`;
                $element.find(`input[name="${plugin.settings.input_name}"]`).val(rate);
            });
            $input_element.on('apply.daterangepicker', function(ev, picker) {
                if(picker.startDate['_d'].getDay() !== picker.endDate['_d'].getDay()) {
                    $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
                } else {
                    $(this).val(picker.startDate.format('YYYY/MM/DD HH:mm') + ' - ' + picker.endDate.format('HH:mm'));
                }
            });
            $input_element.on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });

        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_rates = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_rates')) {
                var plugin = new $.field_rates(this, options);
                $(this).data('field_rates', plugin);
            }
        });
    }
})(jQuery);
