<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlFrontendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$modelCountry = Model::getInstance('countries');
$list = $modelCountry->getList();
foreach ($list as &$item) {
    $item->text = $item->countrycode;
}

$phone_code = $default_phone_code;
$current_country="United States";
$country_code = "USA";

?>
    <div id="<?php esc_attr_e($id_by_name) ?>" class="<?php esc_attr_e($class); ?> field-phonenumber">
        <div class="wrapper-phone-number">
            <input class="countries" value="" type="text">
            <input type="hidden" name="<?php echo (esc_attr($field_name_phone_code)) ?>" value="<?php esc_attr_e($phone_code) ?>">
            <input type="hidden" name="<?php echo (esc_attr($field_name_countrycode)) ?>" value="<?php esc_attr_e($country_code) ?>">
            <input class="phone_number" name="<?php esc_attr_e($name); ?>" value="<?php esc_attr_e($value) ?>"
                   type="text">
        </div>
    </div>
<?php

$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/phonenumber/phonenumber.less');
$doc->addScriptApplySelector('.field-phonenumber','field_phonenumber',array(
    "input_name"=>  $name,
    "list_country"=>  $list,
    "field_name_phone_code"=>$field_name_phone_code,
    "field_name_countrycode"=>$field_name_countrycode,
    "phonecode"=>$phone_code,
    "current_country"=>$current_country,
    "countrycode"=>$country_code,
),'frontend/app/layouts/WooBooking/form/field/phonenumber/phonenumber.jquery.js');