<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

$input = Factory::getInput();
$event_id = $input->getInt('event_id',0);
if($event_id != 0) {
    $id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name).'-'.$event_id;
} else {
    $id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
}
$name_format = str_replace(array('[', ']'), '_', $name);
$paymentsModel = Model::getInstance('payments');
$list_payment = $paymentsModel->getList();
?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="field-paymentsimage-<?php esc_html_e($name_format) ?> field-paymentsimage">
        <ul class="list-payment">
			<?php foreach ($list_payment as $item) { ?>
				<?php
				if ($disable_payment_online && $item->is_payment_online) {
					continue;
				}
				?>
                <li class="<?php echo($item->is_payment_online ? ' payment-online ' : '') ?>">
                    <div class="wrapper-payment" data-payment_id="<?php esc_html_e($item->id); ?>">
                        <div class="non-selected" ><i class="far fa-circle"></i></div>
                        <div class="selected" style="display: none"><i class="fas fa-check-circle"></i></div>
                        <span class="payment-name"><?php esc_html_e($item->name);?></span>
                    </div>
                </li>
			<?php } ?>
        </ul>
        <input type="text" name="<?php esc_html_e($name); ?>" required="true" style="display: none" />
        <input type="hidden" name="<?php esc_html_e($name); ?>" value="<?php esc_html_e($value) ?>" />
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('frontend/app/layouts/WooBooking/form/field/paymentsimage/paymentsimage.less');
$doc->addScriptApplySelector("#$id_by_name",'field_paymentsimage',array(
    "field_name"=>  $name,
),'frontend/app/layouts/WooBooking/form/field/paymentsimage/paymentsimage.jquery.js');