<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

$input = Factory::getInput();
$event_id = $input->getInt('event_id',0);
if($event_id != 0) {
    $id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name).'-'.$event_id;
} else {
    $id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
}
$name_format = str_replace(array('[', ']'), '_', $name);
$paymentsModel = Model::getInstance('payments');
$list_payment = $paymentsModel->getList();
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="field-paymentbutton-<?php echo (esc_attr($name_format)) ?> field-paymentbutton">
        <ul class="list-payment">
			<?php foreach ($list_payment as $item) { ?>
				<?php
				if ($disable_payment_online && $item->is_payment_online) {
					continue;
				}
				?>
                <li class="<?php echo($item->is_payment_online ? ' payment-online ' : '') ?> payment-item" data-payment_id="<?php echo (esc_attr($item->id));?>">
                    <button type="button" class="btn-select-payment" >
                        <div class="img-box">
                            <div>
                                <img class="lazy" data-src="<?php echo (Factory::getRootUrlPlugin())?><?php echo ($item->image);?>" alt="<?php echo (esc_attr($item->name));?>">
                            </div>
                        </div>
                        <p><?php esc_html_e($item->name,'wpbookinghotel');?></p>
                    </button>
                </li>
			<?php } ?>
        </ul>
        <input type="text" name="<?php echo(esc_attr($name)); ?>" required="true" style="display: none" />
        <input type="hidden" name="<?php echo(esc_attr($name)); ?>" value="<?php echo (esc_attr($value)) ?>" />
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('frontend/app/layouts/WooBooking/form/field/paymentbutton/paymentbutton.less');
$doc->addScriptApplySelector("#$id_by_name",'field_paymentbutton',array(
    "field_name"=>  $name,
),'frontend/app/layouts/WooBooking/form/field/paymentbutton/paymentbutton.jquery.js');