<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlFrontendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$input = Factory::getInput();
$hotel_id = $input->getInt('hotel_id',0);
$modelHotel = Model::getInstance('hotel');
$hotel = $modelHotel->getItem($hotel_id);
$max_adult = isset($hotel->max_adult)?$hotel->max_adult:10;

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-number-adult">
        <div class="dropdown main-block">
            <div class="block-top" data-toggle="dropdown">
                <div class="block-content">
                    <div class="adult-content">
                        <span class="number-adult"><?php echo (esc_html($default_value_field_number_adult));?></span>
                        <span><?php esc_html_e('Adult','wpbookinghotel');?></span>
                    </div>
                </div>
                <div class="icon">
                    <i class="far fa-user"></i>
                </div>
            </div>
            <ul class="dropdown-menu">
                <li>
                    <div class="block-select block-select-adult">
                        <div class="content">
                            <span><?php esc_html_e('Number Adult','wpbookinghotel');?></span>
                        </div>
                        <div class="block-increment">
                            <button type="button" class="btn-minius">-</button>
                            <input type="text" class="input-field" value="<?php echo (esc_attr($default_value_field_number_adult));?>">
                            <button type="button" class="btn-plus">+</button>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
        <input type="hidden" name="<?php echo (esc_attr($name));?>" value="<?php echo (esc_attr($default_value_field_number_adult));?>">
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/numberadult/numberadult.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-number-adult','field_numberadult',array(
        "input_name"=>$name,
        "max_adult"=> $max_adult
),'frontend/app/layouts/WooBooking/form/field/numberadult/numberadult.js');