'use strict';
(function ($) {
    $.field_numberadult = function (element, options) {
        var defaults = {
            input_name:'',
            max_adult:0
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;    
        
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let max_adult = plugin.settings.max_adult;
            $element.find('.dropdown-menu').on('click', function (event) {
                event.stopPropagation();
            });
            $element.find('.btn-minius').on('click', function () {
                let $block_increment = $(this).closest('.block-increment');
                let value_current = $block_increment.find('input.input-field').val();
                $block_increment.find('.btn-plus').attr('disabled', false);
                if(value_current > 1) {
                    $block_increment.find('input.input-field').val(parseInt(value_current) - 1);
                    value_current = $block_increment.find('input.input-field').val();
                } else {
                    $(this).attr('disabled', true);
                }
                let $block_select = $(this).closest('.block-select');
                if($block_select.hasClass('block-select-adult')) {
                    $element.find(`input[name="${plugin.settings.input_name}"]`).val(value_current);
                    $element.find('span.number-adult').text(value_current);
                }

            });
            $element.find('.btn-plus').on('click', function () {
                let $block_increment = $(this).closest('.block-increment');
                let value_current = $block_increment.find('input.input-field').val();
                $block_increment.find('.btn-minius').attr('disabled', false);
                if(value_current < parseInt(max_adult)) {
                    $block_increment.find('input.input-field').val(parseInt(value_current) + 1);
                    value_current = $block_increment.find('input.input-field').val();
                    $(this).attr('disabled', false);
                } else {
                    $(this).attr('disabled', true);
                }
                let $block_select = $(this).closest('.block-select');
                if($block_select.hasClass('block-select-adult')) {
                    $element.find(`input[name="${plugin.settings.input_name}"]`).val(value_current);
                    $element.find('span.number-adult').text(value_current);
                }

            });
            $element.find('input.input-field').on('change',  function () {
                let value = $(this).val();
                if(value < 0) {
                    value = 1;
                    $(this).val(value);
                } else if (value > parseInt(max_adult)) {
                    value = max_adult;
                    $(this).val(value);
                }
                let $block_select = $(this).closest('.block-select');
                if($block_select.hasClass('block-select-adult')) {
                    $element.find(`input[name="${plugin.settings.input_name}"]`).val(value);
                    $element.find('span.number-adult').text(value);
                }
            })

        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_numberadult = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_numberadult')) {
                var plugin = new $.field_numberadult(this, options);
                $(this).data('field_numberadult', plugin);
            }
        });
    }
})(jQuery);