<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
$id_by_name = "element_field_". $name;
$name_format = str_replace(array('[', ']'), '_', $name);
$locationsModel = Model::getInstance('destinations');
$list_location = $locationsModel->getList();
$list_selected = is_array($value) ? $value : array();


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>"
         class="<?php echo (esc_attr($class)); ?> field-locations-<?php echo (esc_attr($name_format)) ?> field-locations">
        <select name="<?php echo(esc_attr($name)); ?>" <?php echo ($multiple ? ' multiple ' : null); ?>
                class="form-control list-locations">
            <option value=""><?php esc_html_e('Select location','wpbookinghotel')?></option>
			<?php foreach ($list_location as $location) { ?>
                <option <?php echo (in_array($location->id, $list_selected) ? " selected " : "") ?>
                        value="<?php echo (esc_attr($location->id)); ?>"><?php esc_html_e($location->address,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
$doc->addLessStylesheet('frontend/app/layouts/WooBooking/form/field/locations/locations.less');
$doc->addScriptApplySelector('.field-locations','field_locations',array(
    "field_name"=>  $name,
),'frontend/app/layouts/WooBooking/form/field/locations/locations.jquery.js');
