<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_". $name;
$locationsModel = Model::getInstance('locations');
$list_location = $locationsModel->getList();
?>
    <div id="<?php echo(esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-location">
        <select name="<?php echo (esc_attr($name)); ?>" <?php $multiple ? ' multiple ' : null ?>
                class="form-control list-location">
            <option value="">Select location</option>
			<?php foreach ($list_location as $location) { ?>
                <option <?php echo ($value == $location->id ? ' selected ' : '') ?>
                        value="<?php echo (esc_attr($location->id)); ?>"><?php esc_html_e($location->address,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/location/location.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-location','field_location',array(
),'frontend/app/layouts/WooBooking/form/field/location/location.jquery.js');
