<?php
use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
use WpBookingHotelFrontend\app\Html\HtmlFrontend;

defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlFrontendAlias::load_jquery_library('select2');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$input = Factory::getInput();
$service_id = $input->getInt('service_id',0);
$modelService = Model::getInstance('service');
$list_event=$modelService->getEventByServiceId($service_id);
$service=$modelService->getItem($service_id);
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?>  field-list-event-of-service">
        <?php foreach ($list_event as $item) {?>
            <div class="block-event-item" data-event_id="<?php echo (esc_attr($item->id));?>">
                <div class="row main-event-item">
                    <div class="col-sm-2 col-md-2">
                        <div class="service-image-box">
                            <div>
                                <img src="<?php echo (Factory::getRootUrlPlugin()) ?>/<?php echo ($service->image) ?>" alt="service-image">
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8 col-md-8">
                        <div class="wrapper-event-content">
                            <div class="header-event-content">
                                <h3><?php esc_html_e($item->name,'wpbookinghotel'); ?></h3>
                            </div>
                            <div class="footer">
                                <p>
                                    <span>
                                        <i class="icon-nb-user"></i>
                                        <span>
                                            <?php esc_html_e('Capacity','wpbookinghotel') ?>: <?php echo($item->min_allowed_person . '/' . $item->max_allowed_person); ?>
                                        </span>
                                    </span>
                                    <span>
                                        <i class="icon-nb-pin"></i>
                                        <span>
                                            <?php foreach ($item->list_location as $list_location) {
                                                esc_html_e($list_location->address,'wpbookinghotel');
                                            }
                                            ?>
                                        </span>
                                    </span>
                                </p>
                                <p>
                                    <span>
                                        <i class="icon-nb-clock"></i>
                                        <span>
                                            <?php if($service->duration * 10 % 2 != 0) {?>
                                                <?php esc_html_e('Duration','wpbookinghotel') ?>: <?php printf("%s hours 30 minutes", floor($service->duration)); ?>
                                            <?php } else {?>
                                                <?php esc_html_e('Duration','wpbookinghotel') ?>: <?php printf("%s hours", floor($service->duration)); ?>
                                            <?php } ?>
                                        </span>
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-2 col-md-2 label-price">
                        <div class="wrapper-label">
                            <span class="sticky label label-primary"><?php echo(HtmlFrontend::render_price($item->price))  ?></span>
                        </div>
                    </div>
                </div>
                <div class="row row-button-action">
                    <div class="col-md-12">
                        <div class="wrapper-button-action">
                            <div class="btn-booknow">
                                <span><?php esc_html_e('Book now','wpbookinghotel')?></span>
                                <i class="icon-nb-down-arrow"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php }?>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('frontend/app/layouts/WooBooking/form/field/listeventofservice/listeventofservice.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-list-event-of-service','field_listeventofservice',array(
),'frontend/app/layouts/WooBooking/form/field/listeventofservice/listeventofservice.jquery.js');