<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlFrontend::load_jquery_library('ui');

$id_by_name = "element_field_". $name;
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-filter-price">
        <div class="wrapper-input">
            <input type="text" id="amount_1" readonly/>
        </div>
        <div id="slider-container-1"></div>
        <input type="hidden" name="<?php echo (esc_attr($name))?>">
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/filterprice/filterprice.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-filter-price','field_filter_price',array(
        'input_name'=>$name
),'frontend/app/layouts/WooBooking/form/field/filterprice/filterprice.jquery.js');
