"use strict";
(function ($) {
    $.field_filter_price = function (element, options) {
        var defaults = {
            input_name:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            $element.find('#slider-container-1').slider({
                range: true,
                min: 0,
                max: 1099,
                values: [0, 1099],
                create: function () {
                    $("#amount_1").val("$0 - $1099");
                },
                slide: function (event, ui) {
                    $("#amount_1").val("$" + ui.values[0] + " - $" + ui.values[1]);
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    plugin.filterSystem(mi, mx);
                },
                change: function(event, ui) {
                    var mi = ui.values[0];
                    var mx = ui.values[1];
                    let price_value=[];
                    price_value.push(mi);
                    price_value.push(mx);
                    $element.find(`input[name="${plugin.settings.input_name}"]`).val(JSON.stringify(price_value));
                }
            });
        };
        plugin.filterSystem = function (minPrice, maxPrice) {
            $("#computers div.system").hide().filter(function () {
                var price = parseInt($(this).data("price"), 10);
                return price >= minPrice && price <= maxPrice;
            }).show();
        }
        plugin.example_function = function () {
        };
        plugin.init();
    }
    $.fn.field_filter_price = function (options) {
        return this.each(function () {
            
            if (undefined == $(this).data('field_filter_price')) {
                var plugin = new $.field_filter_price(this, options);
                $(this).data('field_filter_price', plugin);
            }
        });
    }
})(jQuery);