<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlFrontendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelEventTypes = Model::getInstance('eventtypes');
$list = $modelEventTypes->getList();
$list_event_type_id = [];
if (!is_array($value)) {
    $list_event_type_id[] = $value;
} else {
    $list_event_type_id = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-event-type">
        <select name="<?php echo(esc_attr($name)); ?>" <?php echo($multiple ? ' multiple ' : ''); ?>
                class="list-event-type">
            <option value=""><?php esc_html_e('Select event type','wpbookinghotel'); ?></option>
            <?php foreach ($list as $item) { ?>
                <option <?php echo(in_array($item->id, $list_event_type_id) ? ' selected ' : ''); ?>
                        value="<?php echo(esc_attr($item->id)); ?>"><?php esc_html_e($item->name,'wpbookinghotel'); ?></option>
            <?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/eventtype/eventtype.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-event-type','field_event_type',array(
),'frontend/app/layouts/WooBooking/form/field/eventtype/eventtype.js');