<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlFrontendAlias::load_jquery_library('slick');
WpBookingHotelHtmlFrontendAlias::load_jquery_library('fontawesome');

$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);
$name_format = str_replace(array('[', ']'), '_', $name);
$data = $displayData['field']->getForm()->getData();
$input= Factory::getInput();
$service_id= $input->getInt('service_id',0);
if($service_id) {
    $modelService = Model::getInstance('service');
    $service_item = $modelService->getItem($service_id);
    $list_employee = $service_item->list_employee;
} else {
    $event_id = $input->getInt('event_id');
    $modelEmployees = Model::getInstance('employees');
    $list_employee = $modelEmployees->getListEmployeeByEventid($event_id);
}

?>
    <div id="<?php esc_html_e($id_by_name) ?>" class="<?php esc_html_e($class); ?> field-employeeimageslider">
        <div class="list-employee">
                <?php foreach ($list_employee as $item) { ?>
                    <div class="wrapper-employee" data-employee_id="<?php esc_html_e($item->id); ?>">
                        <div class="selected" style="display: none">
                            <span class="icon-nb-select-heart"><span class="path1"></span><span class="path2"></span></span>
                        </div>
                        <div class="img-box">
                            <div>
                                <img class="employee-image" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($item->image); ?>" alt="employee-image" />
                            </div>
                        </div>
                        <p title="<?php esc_html_e($item->full_name); ?>"><?php esc_html_e($item->full_name); ?></p>
                    </div>
                <?php } ?>
            </div>
        <input type="hidden" name="<?php esc_html_e($name); ?>" />
        <span class="left"><i class="icon-nb-arrow-down"></i></span>
        <span class="right"><i class="icon-nb-arrow-down"></i></span>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStylesheet('frontend/app/layouts/WooBooking/form/field/employeeimageslider/employeeimageslider.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-employeeimageslider','field_employeeimageslider',array(
    "field_name"=>  $name
),'frontend/app/layouts/WooBooking/form/field/employeeimageslider/employeeimageslider.jquery.js');