<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);


$id_by_name = "element_field_". $name;
$destinationsModel = Model::getInstance('Locations');
$list_destination = $destinationsModel->getList();

?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-destination">

        <select name="<?php echo (esc_attr($name)); ?>" <?php $multiple ? ' multiple ' : null ?>
                class="form-control list-destination">
            <option value=""><?php esc_html_e('Select destination','wpbookinghotel')?></option>
			<?php foreach ($list_destination as $destination) { ?>
                <option <?php echo ($value == $destination->id ? ' selected ' : '') ?>
                        value="<?php echo (esc_attr($destination->id)); ?>"><?php esc_html_e($destination->address,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
WpBookingHotelHtmlFrontend::load_jquery_library('select2');
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/destination/destination.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.field-destination','field_destination',array(
),'frontend/app/layouts/WooBooking/form/field/destination/destination.jquery.js');
