<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Language\Text;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlBackend as WpBookingHotelHtmlBackendAlias;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);

WpBookingHotelHtmlBackendAlias::load_jquery_library('select2');
$id_by_name = "element_field_". $name;
$data = $displayData['field']->getForm()->getData();
$modelcountries = Model::getInstance('countries');
$list = $modelcountries->getList();
$list_time = [];
$list_country_id = [];
if (!is_array($value)) {
	$list_country_id[] = $value;
} else {
	$list_country_id = $value;
}
?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> field-countries">
        <select name="<?php echo (esc_attr($name)); ?>" required="<?php echo (esc_attr($required)) ?>" <?php echo($multiple ? ' multiple ' : null); ?>class="list-country">
            <option value=""><?php esc_attr_e('Select country','wpbookinghotel') ?></option>
			<?php foreach ($list as $item) { ?>
                <option value="<?php echo (esc_attr($item->id)); ?>"><?php esc_html_e($item->countryname,'wpbookinghotel'); ?></option>
			<?php } ?>
        </select>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/countries/countries.less');
$doc->addScriptApplySelector('.field-countries','field_countries',array(
),'frontend/app/layouts/WooBooking/form/field/countries/countries.jquery.js');