<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlFrontendAlias::load_jquery_library('moment');
WpBookingHotelHtmlFrontendAlias::load_jquery_library('daterangepicker');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> element-field-checkout2">
        <div class="input-date-checkout2">
            <input type="text" class="check-out" id="check-out">
            <i class="far fa-calendar-alt"></i>
            <input type="hidden" name="<?php echo (esc_attr($name));?>">
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/checkout2/checkout2.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.element-field-checkout2','field_checkout2',array(
        "input_name"=>$name
),'frontend/app/layouts/WooBooking/form/field/checkout2/checkout2.js');