'use strict';
(function ($) {
    $.field_checkout2 = function (element, options) {
        var defaults = {
            input_name:''
        }
        var plugin = this;
        plugin.settings = {}
        var $element = $(element), 
            element = element;    
        
        plugin.init = function () {
            plugin.settings = $.extend({}, defaults, options);
            let now = new Date();
            $element.find('input[id="check-out"]').daterangepicker({
                singleDatePicker: true,
                showDropdowns: true,
                minYear: 1970,
                locale: {
                    format: 'YYYY-MM-DD'
                },
                maxYear: '+10',
                minDate: now
            }, function (start, end, label) {
                var years = moment().diff(start, 'years');
                $(`input[name="${plugin.settings.input_name}"]`).val(start.format('YYYY-MM-DD'));
            });
        };
        plugin.example_function = function () {
        };
        plugin.init();
    }
    
    $.fn.field_checkout2 = function (options) {
        
        return this.each(function () {
            
            if (undefined == $(this).data('field_checkout2')) {
                var plugin = new $.field_checkout2(this, options);
                $(this).data('field_checkout2', plugin);
            }
        });
    }
})(jQuery);