<?php

use WpBookingHotel\Factory;
use WpBookingHotel\Mvc\Model\Model;
use WpBookingHotel\Utilities\Utility;
use WpBookingHotel\Html\WpBookingHotelHtmlFrontend as WpBookingHotelHtmlFrontendAlias;
use WpBookingHotel\Language\Text;
defined('_WPBOOKINGHOTEL_EXEC') or die;
extract($displayData);
WpBookingHotelHtmlFrontendAlias::load_jquery_library('moment');
WpBookingHotelHtmlFrontendAlias::load_jquery_library('daterangepicker');
$id_by_name = "element_field_" . str_replace(array('[', ']'), '_', $name);


?>
    <div id="<?php echo (esc_attr($id_by_name)) ?>" class="<?php echo (esc_attr($class)); ?> element-field-checkin2">
        <div class="input-date-checkin2">
            <input type="text" class="check-in" id="check-in">
            <i class="far fa-calendar-alt"></i>
            <input type="hidden" name="<?php echo (esc_attr($name));?>">
        </div>
    </div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/layouts/WooBooking/form/field/checkin2/checkin2.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.element-field-checkin2','field_checkin2',array(
        "input_name"=>$name
),'frontend/app/layouts/WooBooking/form/field/checkin2/checkin2.js');